/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcLREAL
extends PlcIECValue<Double> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static Double minValue = -1.7976931348623157E308;
    static Double maxValue = Double.MAX_VALUE;

    public static PlcLREAL of(Object value) {
        if (value instanceof Boolean) {
            return new PlcLREAL((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcLREAL((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLREAL((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLREAL((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLREAL(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new PlcLREAL((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLREAL((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLREAL((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLREAL((BigDecimal)value);
        }
        return new PlcLREAL((String)value);
    }

    public PlcLREAL(Boolean value) {
        this.value = value != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
        this.isNullable = false;
    }

    public PlcLREAL(Byte value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Short value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Integer value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Float value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Double value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcLREAL(BigInteger value) {
        BigDecimal val = new BigDecimal(value);
        if (val.compareTo(BigDecimal.valueOf(minValue)) < 0 || val.compareTo(BigDecimal.valueOf(maxValue)) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val.doubleValue();
        this.isNullable = true;
    }

    public PlcLREAL(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.doubleValue();
        this.isNullable = true;
    }

    public PlcLREAL(String value) {
        try {
            this.value = Double.parseDouble(value.trim());
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcLREAL(@JsonProperty(value="value") double value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.LREAL;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Double)this.value).equals(0.0);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Double)this.value <= 127.0 && (Double)this.value >= -128.0;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Double)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && (Double)this.value <= 32767.0 && (Double)this.value >= -32768.0;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Double)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && (Double)this.value <= 2.147483647E9 && (Double)this.value >= -2.147483648E9;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Double)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return this.value != null && (Double)this.value <= 9.223372036854776E18 && (Double)this.value >= -9.223372036854776E18;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Double)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return this.value != null && (Double)this.value <= 3.4028234663852886E38 && (Double)this.value >= -3.4028234663852886E38;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Double)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return (Double)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal((Double)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Double.toString((Double)this.value);
    }

    @JsonIgnore
    public byte[] getBytes() {
        long longBits = Double.doubleToRawLongBits((Double)this.value);
        return new byte[]{(byte)(longBits >> 56 & 0xFFL), (byte)(longBits >> 48 & 0xFFL), (byte)(longBits >> 40 & 0xFFL), (byte)(longBits >> 32 & 0xFFL), (byte)(longBits >> 24 & 0xFFL), (byte)(longBits >> 16 & 0xFFL), (byte)(longBits >> 8 & 0xFFL), (byte)(longBits & 0xFFL)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeDouble(this.getClass().getSimpleName(), 64, (Double)this.value, new WithWriterArgs[0]);
    }
}

