/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageCodec;
import io.vavr.control.Either;
import java.time.Duration;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.TimedOperation;
import org.apache.plc4x.java.spi.TimeoutManager;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.events.CloseConnectionEvent;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.events.DisconnectedEvent;
import org.apache.plc4x.java.spi.events.DiscoverEvent;
import org.apache.plc4x.java.spi.events.DiscoveredEvent;
import org.apache.plc4x.java.spi.internal.DefaultConversationContext;
import org.apache.plc4x.java.spi.internal.DefaultExpectRequestContext;
import org.apache.plc4x.java.spi.internal.DefaultSendRequestContext;
import org.apache.plc4x.java.spi.internal.HandlerRegistration;
import org.apache.plc4x.java.spi.netty.NettyHashTimerTimeoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4xNettyWrapper<T>
extends MessageToMessageCodec<T, Object> {
    private static final Logger logger = LoggerFactory.getLogger(Plc4xNettyWrapper.class);
    private final Plc4xProtocolBase<T> protocolBase;
    private final PlcAuthentication authentication;
    private final Queue<HandlerRegistration> registeredHandlers;
    private final boolean passive;
    private final TimeoutManager timeoutManager;

    public Plc4xNettyWrapper(ChannelPipeline pipeline, boolean passive, Plc4xProtocolBase<T> protocol, PlcAuthentication authentication, Class<T> clazz) {
        this(new NettyHashTimerTimeoutManager(), pipeline, passive, protocol, authentication, clazz);
    }

    public Plc4xNettyWrapper(TimeoutManager timeoutManager, final ChannelPipeline pipeline, final boolean passive, Plc4xProtocolBase<T> protocol, final PlcAuthentication authentication, Class<T> clazz) {
        super(clazz, Object.class);
        this.passive = passive;
        this.registeredHandlers = new ConcurrentLinkedQueue<HandlerRegistration>();
        this.protocolBase = protocol;
        this.authentication = authentication;
        this.timeoutManager = timeoutManager;
        this.protocolBase.setContext(new ConversationContext<T>(){

            @Override
            public PlcAuthentication getAuthentication() {
                return authentication;
            }

            @Override
            public Channel getChannel() {
                return pipeline.channel();
            }

            @Override
            public boolean isPassive() {
                return passive;
            }

            @Override
            public void sendToWire(T msg) {
                pipeline.writeAndFlush(msg);
            }

            @Override
            public void fireConnected() {
                pipeline.fireUserEventTriggered(ConnectedEvent.class);
            }

            @Override
            public void fireDisconnected() {
                pipeline.fireUserEventTriggered(DisconnectedEvent.class);
            }

            @Override
            public void fireDiscovered(Configuration c) {
                pipeline.fireUserEventTriggered(DiscoveredEvent.class);
            }

            @Override
            public ConversationContext.SendRequestContext<T> sendRequest(T packet) {
                return new DefaultSendRequestContext(arg_0 -> Plc4xNettyWrapper.access$0(Plc4xNettyWrapper.this, arg_0), packet, this);
            }

            @Override
            public ConversationContext.ExpectRequestContext<T> expectRequest(Class<T> clazz, Duration timeout) {
                return new DefaultExpectRequestContext(arg_0 -> Plc4xNettyWrapper.access$0(Plc4xNettyWrapper.this, arg_0), clazz, timeout, this);
            }
        });
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        super.close(ctx, promise);
        this.timeoutManager.stop();
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, Object msg, List<Object> list) throws Exception {
        logger.debug("Forwarding request to plc {}", msg);
        list.add(msg);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, T t, List<Object> list) throws Exception {
        logger.trace("Decoding {}", t);
        Iterator iter = this.registeredHandlers.iterator();
        block0: while (iter.hasNext()) {
            HandlerRegistration registration = (HandlerRegistration)iter.next();
            if (registration.isCancelled()) {
                logger.debug("Removing {} as it was cancelled!", (Object)registration);
                iter.remove();
                continue;
            }
            logger.trace("Checking handler {} for Object of type {}", (Object)registration, (Object)t.getClass().getSimpleName());
            if (!registration.getExpectClazz().isInstance(t)) continue;
            logger.trace("Handler {} has right expected type {}, checking condition", (Object)registration, (Object)registration.getExpectClazz().getSimpleName());
            Deque<Either<Function<?, ?>, Predicate<?>>> commands = registration.getCommands();
            Object instance = t;
            for (Either<Function<?, ?>, Predicate<?>> either : commands) {
                if (either.isLeft()) {
                    Function unwrap = (Function)either.getLeft();
                    instance = unwrap.apply(instance);
                    continue;
                }
                Predicate predicate = (Predicate)either.get();
                if (predicate.test(instance)) continue;
                logger.trace("Registration {} with predicate {} does not match object {} (currently wrapped to {})", new Object[]{registration, predicate, t.getClass().getSimpleName(), instance.getClass().getSimpleName()});
                continue block0;
            }
            logger.trace("Handler {} accepts element {}, calling handle method", (Object)registration, t);
            this.registeredHandlers.remove(registration);
            Consumer<?> handler = registration.getPacketConsumer();
            handler.accept(instance);
            registration.confirmHandled();
            return;
        }
        logger.trace("None of {} registered handlers could handle message {}, using default decode method", (Object)this.registeredHandlers.size(), t);
        this.protocolBase.decode(new DefaultConversationContext(this::registerHandler, channelHandlerContext, this.authentication, this.passive), t);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.debug("User Event triggered {}", evt);
        if (evt instanceof ConnectEvent) {
            this.protocolBase.onConnect(new DefaultConversationContext(this::registerHandler, ctx, this.authentication, this.passive));
        } else if (evt instanceof DisconnectEvent) {
            this.protocolBase.onDisconnect(new DefaultConversationContext(this::registerHandler, ctx, this.authentication, this.passive));
        } else if (evt instanceof DiscoverEvent) {
            this.protocolBase.onDiscover(new DefaultConversationContext(this::registerHandler, ctx, this.authentication, this.passive));
        } else if (evt instanceof CloseConnectionEvent) {
            this.protocolBase.close(new DefaultConversationContext(this::registerHandler, ctx, this.authentication, this.passive));
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void registerHandler(final HandlerRegistration handler) {
        final AtomicReference<HandlerRegistration> deferred = new AtomicReference<HandlerRegistration>();
        TimeoutManager.CompletionCallback<?> completionCallback = this.timeoutManager.register(new TimedOperation(){

            @Override
            public Consumer<TimeoutException> getOnTimeoutConsumer() {
                return Plc4xNettyWrapper.this.onTimeout(deferred, handler.getOnTimeoutConsumer());
            }

            @Override
            public Duration getTimeout() {
                return handler.getTimeout();
            }
        });
        HandlerRegistration registration = new HandlerRegistration(handler.getCommands(), handler.getExpectClazz(), completionCallback.andThen(handler.getPacketConsumer()), handler.getOnTimeoutConsumer(), handler.getErrorConsumer(), handler.getTimeout());
        deferred.set(registration);
        this.registeredHandlers.add(registration);
    }

    private Consumer<TimeoutException> onTimeout(final AtomicReference<HandlerRegistration> reference, final Consumer<TimeoutException> onTimeoutConsumer) {
        return new Consumer<TimeoutException>(){

            @Override
            public void accept(TimeoutException e) {
                Plc4xNettyWrapper.this.registeredHandlers.remove(reference.get());
                onTimeoutConsumer.accept(e);
            }
        };
    }

    static /* synthetic */ void access$0(Plc4xNettyWrapper plc4xNettyWrapper, HandlerRegistration handlerRegistration) {
        plc4xNettyWrapper.registerHandler(handlerRegistration);
    }
}

