/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageInput;
import org.apache.plc4x.java.spi.generation.MessageOutput;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratedDriverByteToMessageCodec<T extends Message>
extends ByteToMessageCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratedDriverByteToMessageCodec.class);
    private final ByteOrder byteOrder;
    private final MessageInput<T> messageInput;
    private final MessageOutput<T> messageOutput;

    protected GeneratedDriverByteToMessageCodec(MessageInput<T> messageInput, MessageOutput<T> messageOutput, Class<T> outboundMessageType, ByteOrder byteOrder) {
        super(outboundMessageType);
        this.messageInput = messageInput;
        this.messageOutput = messageOutput;
        this.byteOrder = byteOrder;
    }

    protected void encode(ChannelHandlerContext ctx, T packet, ByteBuf byteBuf) {
        try {
            WriteBufferByteBased buffer;
            if (this.messageOutput != null) {
                buffer = this.messageOutput.serialize(packet);
            } else {
                buffer = new WriteBufferByteBased(packet.getLengthInBytes(), this.byteOrder);
                packet.serialize(buffer);
            }
            byteBuf.writeBytes(buffer.getBytes());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending bytes to PLC for message {} as data {}", packet, (Object)Hex.encodeHexString((byte[])buffer.getBytes()));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error encoding package [{}]: {}", new Object[]{packet, e.getMessage(), e});
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) {
        LOGGER.trace("Receiving bytes, trying to decode Message...");
        while (byteBuf.readableBytes() > 0) {
            byte[] bytes = null;
            try {
                int packetSize = this.getPacketSize(byteBuf);
                if (packetSize == -1 || packetSize > byteBuf.readableBytes()) {
                    return;
                }
                bytes = new byte[packetSize];
                byteBuf.readBytes(bytes);
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(bytes, this.byteOrder);
                Message packet = (Message)this.messageInput.parse(readBuffer);
                out.add(packet);
                if (out.size() < 16) continue;
                return;
            }
            catch (Exception e) {
                if (bytes != null) {
                    LOGGER.warn("Error decoding package with content [{}]: {}", new Object[]{Hex.encodeHexString(bytes), e.getMessage(), e});
                }
                this.removeRestOfCorruptPackage(byteBuf);
            }
        }
    }

    protected abstract int getPacketSize(ByteBuf var1);

    protected abstract void removeRestOfCorruptPackage(ByteBuf var1);
}

