/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.util.Optional;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldWriterOptional<T>
implements FieldCommons,
WithReaderWriterArgs {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldWriterOptional.class);

    public void writeOptionalField(String logicalName, T value, DataWriter<T> dataWriter, boolean condition, WithWriterArgs ... writerArgs) throws SerializationException {
        LOGGER.debug("write field {}", (Object)logicalName);
        if (condition && value != null) {
            this.switchSerializeByteOrderIfNecessary(() -> dataWriter.write(logicalName, value, writerArgs), dataWriter, this.extractByteOrder(writerArgs).orElse(null));
        } else {
            WriteBuffer writeBuffer = dataWriter.getWriteBuffer();
            if (writeBuffer instanceof WriteBufferByteBased) {
                Optional<String> nullByteHexOptional = this.extractNullBytesHex(writerArgs);
                if (nullByteHexOptional.isPresent()) {
                    String nullByteHex = nullByteHexOptional.get();
                    try {
                        byte[] nullBytes = Hex.decodeHex((String)nullByteHex);
                        writeBuffer.writeByteArray(logicalName, nullBytes, writerArgs);
                    }
                    catch (DecoderException decoderException) {}
                } else {
                    LOGGER.debug("field {} not written because value is null({}) or condition({}) didn't evaluate to true", new Object[]{logicalName, value != null, condition});
                }
            }
        }
    }
}

