/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedOperationException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcPinger;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagValueItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlcConnection
implements PlcConnection,
PlcConnectionMetadata,
PlcPinger,
PlcReader,
PlcWriter,
PlcSubscriber,
PlcBrowser {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractPlcConnection.class);
    private boolean canPing = false;
    private boolean canRead = false;
    private boolean canWrite = false;
    private boolean canSubscribe = false;
    private boolean canBrowse = false;
    private final PlcValueHandler valueHandler;
    private final BaseOptimizer optimizer;
    private final PlcAuthentication authentication;
    private Plc4xProtocolBase<? extends Message> protocol;
    private PlcTagHandler tagHandler;

    protected AbstractPlcConnection(boolean canPing, boolean canRead, boolean canWrite, boolean canSubscribe, boolean canBrowse, PlcValueHandler valueHandler, BaseOptimizer optimizer, PlcAuthentication authentication) {
        this.canPing = canPing;
        this.canRead = canRead;
        this.canWrite = canWrite;
        this.canSubscribe = canSubscribe;
        this.canBrowse = canBrowse;
        this.valueHandler = valueHandler;
        this.optimizer = optimizer;
        this.authentication = authentication;
    }

    protected AbstractPlcConnection(boolean canPing, boolean canRead, boolean canWrite, boolean canSubscribe, boolean canBrowse, PlcValueHandler valueHandler, PlcTagHandler tagHandler, BaseOptimizer optimizer, PlcAuthentication authentication) {
        this.canPing = canPing;
        this.canRead = canRead;
        this.canWrite = canWrite;
        this.canSubscribe = canSubscribe;
        this.canBrowse = canBrowse;
        this.valueHandler = valueHandler;
        this.tagHandler = tagHandler;
        this.optimizer = optimizer;
        this.authentication = authentication;
    }

    public void setProtocol(Plc4xProtocolBase<? extends Message> protocol) {
        this.protocol = protocol;
        this.tagHandler = protocol.getTagHandler();
    }

    public Plc4xProtocolBase<? extends Message> getProtocol() {
        return this.protocol;
    }

    public PlcConnectionMetadata getMetadata() {
        return this;
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)new PlcUnsupportedOperationException("The connection does not support pinging"));
        return future;
    }

    public boolean isReadSupported() {
        return this.canRead;
    }

    public boolean isWriteSupported() {
        return this.canWrite;
    }

    public boolean isSubscribeSupported() {
        return this.canSubscribe;
    }

    public boolean isBrowseSupported() {
        return this.canBrowse;
    }

    public PlcTagHandler getPlcTagHandler() {
        return this.tagHandler;
    }

    public PlcValueHandler getPlcValueHandler() {
        return this.valueHandler;
    }

    protected PlcAuthentication getAuthentication() {
        return this.authentication;
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        if (!this.isReadSupported()) {
            throw new PlcUnsupportedOperationException("The connection does not support reading");
        }
        return new DefaultPlcReadRequest.Builder(this, this.getPlcTagHandler());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        if (!this.isWriteSupported()) {
            throw new PlcUnsupportedOperationException("The connection does not support writing");
        }
        return new DefaultPlcWriteRequest.Builder(this, this.getPlcTagHandler(), this.getPlcValueHandler());
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        if (!this.isSubscribeSupported()) {
            throw new PlcUnsupportedOperationException("The connection does not support subscription");
        }
        return new DefaultPlcSubscriptionRequest.Builder(this, this.getPlcTagHandler());
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        if (!this.canSubscribe) {
            throw new PlcUnsupportedOperationException("The connection does not support subscription");
        }
        return new DefaultPlcUnsubscriptionRequest.Builder(this);
    }

    public PlcBrowseRequest.Builder browseRequestBuilder() {
        if (!this.canBrowse) {
            throw new PlcUnsupportedOperationException("The connection does not support browsing");
        }
        return new DefaultPlcBrowseRequest.Builder(this, this.getPlcTagHandler());
    }

    @Override
    public CompletableFuture<PlcPingResponse> ping(PlcPingRequest pingRequest) {
        if (!this.canPing) {
            throw new PlcUnsupportedOperationException("The connection does not support pinging");
        }
        return this.protocol.ping(pingRequest);
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        PlcReadRequest filteredReadRequest = this.getFilteredReadRequest((DefaultPlcReadRequest)readRequest);
        return this.internalRead(filteredReadRequest).thenApply(filteredReadResponse -> {
            if (readRequest.getNumberOfTags() == filteredReadRequest.getNumberOfTags()) {
                return filteredReadResponse;
            }
            HashMap<String, PlcResponseItem<PlcValue>> values = new HashMap<String, PlcResponseItem<PlcValue>>();
            for (String tagName : readRequest.getTagNames()) {
                if (filteredReadRequest.getTagResponseCode(tagName) != null) {
                    values.put(tagName, ((DefaultPlcReadResponse)filteredReadResponse).getPlcResponseItem(tagName));
                    continue;
                }
                values.put(tagName, new DefaultPlcResponseItem<Object>(readRequest.getTagResponseCode(tagName), null));
            }
            return new DefaultPlcReadResponse(readRequest, values);
        });
    }

    protected CompletableFuture<PlcReadResponse> internalRead(PlcReadRequest readRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedRead(readRequest, this.protocol);
        }
        return this.protocol.read(readRequest);
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        PlcWriteRequest filteredWriteRequest = this.getFilteredWriteRequest((DefaultPlcWriteRequest)writeRequest);
        return this.internalWrite(filteredWriteRequest).thenApply(filteredWriteResponse -> {
            if (writeRequest.getNumberOfTags() == filteredWriteRequest.getNumberOfTags()) {
                return filteredWriteResponse;
            }
            HashMap<String, PlcResponseCode> values = new HashMap<String, PlcResponseCode>();
            for (String tagName : writeRequest.getTagNames()) {
                if (filteredWriteRequest.getTagResponseCode(tagName) != null) {
                    values.put(tagName, filteredWriteResponse.getResponseCode(tagName));
                    continue;
                }
                values.put(tagName, writeRequest.getTagResponseCode(tagName));
            }
            return new DefaultPlcWriteResponse(writeRequest, values);
        });
    }

    protected CompletableFuture<PlcWriteResponse> internalWrite(PlcWriteRequest writeRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedWrite(writeRequest, this.protocol);
        }
        return this.protocol.write(writeRequest);
    }

    @Override
    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        PlcSubscriptionRequest filteredSubscriptionRequest = this.getFilteredSubscriptionRequest((DefaultPlcSubscriptionRequest)subscriptionRequest);
        return this.internalSubscribe(filteredSubscriptionRequest).thenApply(filteredSubscriptionResponse -> {
            if (subscriptionRequest.getNumberOfTags() == filteredSubscriptionRequest.getNumberOfTags()) {
                return filteredSubscriptionResponse;
            }
            HashMap<String, PlcResponseItem<PlcSubscriptionHandle>> values = new HashMap<String, PlcResponseItem<PlcSubscriptionHandle>>();
            for (String tagName : subscriptionRequest.getTagNames()) {
                if (filteredSubscriptionRequest.getTagResponseCode(tagName) != null) {
                    values.put(tagName, new DefaultPlcResponseItem<PlcSubscriptionHandle>(filteredSubscriptionRequest.getTagResponseCode(tagName), filteredSubscriptionResponse.getSubscriptionHandle(tagName)));
                    continue;
                }
                values.put(tagName, new DefaultPlcResponseItem<Object>(subscriptionRequest.getTagResponseCode(tagName), null));
            }
            return new DefaultPlcSubscriptionResponse(subscriptionRequest, values);
        });
    }

    public CompletableFuture<PlcSubscriptionResponse> internalSubscribe(PlcSubscriptionRequest subscriptionRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedSubscribe(subscriptionRequest, this.protocol);
        }
        return this.protocol.subscribe(subscriptionRequest);
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedUnsubscribe(unsubscriptionRequest, this.protocol);
        }
        return this.protocol.unsubscribe(unsubscriptionRequest);
    }

    @Override
    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        throw new NotImplementedException("");
    }

    @Override
    public void unregister(PlcConsumerRegistration registration) {
        throw new NotImplementedException("");
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        return this.protocol.browse(browseRequest);
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browseWithInterceptor(PlcBrowseRequest browseRequest, PlcBrowseRequestInterceptor interceptor) {
        return this.protocol.browseWithInterceptor(browseRequest, interceptor);
    }

    public Optional<PlcTag> parseTagAddress(String tagAddress) {
        PlcTag plcTag;
        try {
            plcTag = this.tagHandler.parseTag(tagAddress);
        }
        catch (Exception e) {
            throw new PlcRuntimeException("Error parsing tag address: " + tagAddress, (Throwable)e);
        }
        return Optional.ofNullable(plcTag);
    }

    public Optional<PlcValue> parseTagValue(PlcTag tag, Object ... values) {
        PlcValue plcValue;
        try {
            plcValue = this.valueHandler.newPlcValue(tag, values);
        }
        catch (Exception e) {
            throw new PlcRuntimeException("Error parsing tag value " + tag, (Throwable)e);
        }
        return Optional.of(plcValue);
    }

    protected PlcReadRequest getFilteredReadRequest(DefaultPlcReadRequest readRequest) {
        LinkedHashMap<String, PlcTagItem<PlcTag>> filteredTags = new LinkedHashMap<String, PlcTagItem<PlcTag>>();
        for (String tagName : readRequest.getTagNames()) {
            if (readRequest.getTagResponseCode(tagName) != PlcResponseCode.OK) continue;
            filteredTags.put(tagName, readRequest.getTagItem(tagName));
        }
        return new DefaultPlcReadRequest(readRequest.getReader(), filteredTags);
    }

    protected PlcWriteRequest getFilteredWriteRequest(DefaultPlcWriteRequest writeRequest) {
        LinkedHashMap<String, PlcTagValueItem<PlcTag>> filteredTags = new LinkedHashMap<String, PlcTagValueItem<PlcTag>>();
        for (String tagName : writeRequest.getTagNames()) {
            if (writeRequest.getTagResponseCode(tagName) != PlcResponseCode.OK) continue;
            filteredTags.put(tagName, writeRequest.getTagValueItem(tagName));
        }
        return new DefaultPlcWriteRequest(writeRequest.getWriter(), filteredTags);
    }

    protected PlcSubscriptionRequest getFilteredSubscriptionRequest(DefaultPlcSubscriptionRequest subscriptionRequest) {
        LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>> filteredTags = new LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>>();
        LinkedHashMap<String, Consumer<PlcSubscriptionEvent>> filteredConsumers = new LinkedHashMap<String, Consumer<PlcSubscriptionEvent>>();
        for (String tagName : subscriptionRequest.getTagNames()) {
            if (subscriptionRequest.getTagResponseCode(tagName) != PlcResponseCode.OK) continue;
            filteredTags.put(tagName, new DefaultPlcTagItem<PlcSubscriptionTag>(subscriptionRequest.getTag(tagName)));
            if (subscriptionRequest.getTagConsumer(tagName) == null) continue;
            filteredConsumers.put(tagName, subscriptionRequest.getTagConsumer(tagName));
        }
        return new DefaultPlcSubscriptionRequest(subscriptionRequest.getSubscriber(), filteredTags, subscriptionRequest.getConsumer(), filteredConsumers);
    }
}

