/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcDiscoveryItem
implements PlcDiscoveryItem,
Serializable {
    private final String protocolCode;
    private final String transportCode;
    private final String transportUrl;
    private final Map<String, String> options;
    private final String name;
    private final Map<String, PlcValue> attributes;

    public DefaultPlcDiscoveryItem(String protocolCode, String transportCode, String transportUrl, Map<String, String> options, String name, Map<String, PlcValue> attributes) {
        this.protocolCode = protocolCode;
        this.transportCode = transportCode;
        this.transportUrl = transportUrl;
        this.options = options;
        this.name = name;
        this.attributes = attributes;
    }

    public String getProtocolCode() {
        return this.protocolCode;
    }

    public String getTransportCode() {
        return this.transportCode;
    }

    public String getTransportUrl() {
        return this.transportUrl;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, PlcValue> getAttributes() {
        return this.attributes;
    }

    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder(String.format("%s:%s://%s", this.protocolCode, this.transportCode, this.transportUrl.toString()));
        if (this.options != null && !this.options.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String> optionEntry : this.options.entrySet()) {
                if (first) {
                    sb.append("?");
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(optionEntry.getKey()).append("=").append(optionEntry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcDiscoveryItem", new WithWriterArgs[0]);
        writeBuffer.writeString("protocolCode", this.protocolCode.getBytes(StandardCharsets.UTF_8).length * 8, this.protocolCode, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        writeBuffer.writeString("transportCode", this.transportCode.getBytes(StandardCharsets.UTF_8).length * 8, this.transportCode, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        writeBuffer.writeString("transportUrl", this.transportUrl.toString().getBytes(StandardCharsets.UTF_8).length * 8, this.transportUrl.toString(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        if (this.options != null && !this.options.isEmpty()) {
            writeBuffer.pushContext("options", new WithWriterArgs[0]);
            for (Map.Entry<String, String> optionEntry : this.options.entrySet()) {
                writeBuffer.pushContext("option", new WithWriterArgs[0]);
                writeBuffer.writeString("name", optionEntry.getKey().getBytes(StandardCharsets.UTF_8).length * 8, optionEntry.getKey(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
                writeBuffer.writeString("value", optionEntry.getValue().getBytes(StandardCharsets.UTF_8).length * 8, optionEntry.getValue(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
                writeBuffer.popContext("option", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("options", new WithWriterArgs[0]);
        }
        if (this.name != null && !this.name.isEmpty()) {
            writeBuffer.writeString("name", this.name.getBytes(StandardCharsets.UTF_8).length * 8, this.name, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        }
        writeBuffer.popContext("PlcDiscoveryItem", new WithWriterArgs[0]);
    }
}

