/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.Metadata;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcWriteResponse
implements PlcWriteResponse,
Serializable {
    private final PlcWriteRequest request;
    private final Map<String, PlcResponseCode> responseCodes;
    private final Map<String, Metadata> metadata;

    public DefaultPlcWriteResponse(PlcWriteRequest request, Map<String, PlcResponseCode> responseCodes) {
        this(request, responseCodes, Collections.emptyMap());
    }

    public DefaultPlcWriteResponse(PlcWriteRequest request, Map<String, PlcResponseCode> responseCodes, Map<String, Metadata> metadata) {
        this.request = request;
        this.responseCodes = responseCodes;
        this.metadata = metadata;
    }

    public PlcWriteRequest getRequest() {
        return this.request;
    }

    public Metadata getTagMetadata(String tag) {
        return this.metadata.getOrDefault(tag, Metadata.EMPTY);
    }

    public Collection<String> getTagNames() {
        return this.request.getTagNames();
    }

    public PlcTag getTag(String name) {
        return this.request.getTag(name);
    }

    public PlcResponseCode getResponseCode(String name) {
        return this.responseCodes.get(name);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcWriteResponse", new WithWriterArgs[0]);
        writeBuffer.pushContext("request", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.popContext("request", new WithWriterArgs[0]);
        writeBuffer.pushContext("responseCodes", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, PlcResponseCode> entry : this.responseCodes.entrySet()) {
            String tagName = entry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcResponseCode tagResponseCode = entry.getValue();
            writeBuffer.writeUnsignedByte("ResponseCode", 8, (byte)tagResponseCode.getValue(), WithReaderWriterArgs.WithAdditionalStringRepresentation(tagResponseCode.name()));
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("responseCodes", new WithWriterArgs[0]);
        if (this.metadata != null && !this.metadata.isEmpty()) {
            writeBuffer.pushContext("metadata", WithReaderWriterArgs.WithRenderAsList(true));
            for (Map.Entry<String, PlcResponseCode> entry : this.metadata.entrySet()) {
                if (!(entry.getValue() instanceof Serializable)) continue;
                writeBuffer.pushContext(entry.getKey(), new WithWriterArgs[0]);
                ((Serializable)entry.getValue()).serialize(writeBuffer);
                writeBuffer.popContext(entry.getKey(), new WithWriterArgs[0]);
            }
            writeBuffer.popContext("metadata", new WithWriterArgs[0]);
        }
        writeBuffer.popContext("PlcWriteResponse", new WithWriterArgs[0]);
    }
}

