/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcBOOL
extends PlcIECValue<Boolean> {
    private static final String VALUE_OUT_OF_RANGE = "Value of is required for a %s Value";

    public static PlcBOOL of(Object value) {
        if (value instanceof PlcBOOL) {
            return (PlcBOOL)value;
        }
        if (value instanceof Boolean) {
            return new PlcBOOL((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcBOOL((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcBOOL((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcBOOL((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcBOOL((Long)value);
        }
        if (value instanceof Float) {
            return new PlcBOOL((Float)value);
        }
        if (value instanceof Double) {
            return new PlcBOOL((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcBOOL((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcBOOL((BigDecimal)value);
        }
        return new PlcBOOL(value.toString());
    }

    public PlcBOOL(Boolean value) {
        this.value = value;
        this.isNullable = true;
    }

    public PlcBOOL(Byte value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value != 0;
        this.isNullable = true;
    }

    public PlcBOOL(Short value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value != 0;
        this.isNullable = true;
    }

    public PlcBOOL(Integer value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value != 0;
        this.isNullable = true;
    }

    public PlcBOOL(Long value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value != 0L;
        this.isNullable = true;
    }

    public PlcBOOL(Float value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = (double)value.floatValue() != 0.0;
        this.isNullable = true;
    }

    public PlcBOOL(Double value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value != 0.0;
        this.isNullable = true;
    }

    public PlcBOOL(BigInteger value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value.compareTo(BigInteger.ZERO) != 0;
        this.isNullable = true;
    }

    public PlcBOOL(BigDecimal value) {
        if (value == null) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, this.getClass().getSimpleName()));
        }
        this.value = value.compareTo(BigDecimal.ZERO) != 0;
        this.isNullable = true;
    }

    public PlcBOOL(String value) {
        try {
            this.value = this.parseValue(value);
            this.isNullable = false;
        }
        catch (RuntimeException e) {
            throw new PlcInvalidTagException(String.format("Value %s could not be parsed to %s Value", value, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private boolean parseValue(String value) {
        try {
            return Integer.parseInt(value.trim()) > 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value.trim());
        }
    }

    public PlcBOOL(boolean value) {
        this.value = value;
        this.isNullable = true;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.BOOL;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && (Boolean)this.value != false;
    }

    @Override
    public boolean isByte() {
        return true;
    }

    @Override
    public byte getByte() {
        return (byte)(this.value != null && (Boolean)this.value != false ? 1 : 0);
    }

    @Override
    public boolean isShort() {
        return true;
    }

    @Override
    public short getShort() {
        return (short)(this.value != null && (Boolean)this.value != false ? 1 : 0);
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return this.value != null && (Boolean)this.value != false ? 1 : 0;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return this.value != null && (Boolean)this.value != false ? 1 : 0;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return (Boolean)this.value != false ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return this.value != null && (Boolean)this.value != false ? 1.0f : 0.0f;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return this.value != null && (Boolean)this.value != false ? 1.0 : 0.0;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return (Boolean)this.value != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        byte[] byArray;
        if (this.value != null && ((Boolean)this.value).booleanValue()) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byArray = new byte[1];
        }
        return byArray;
    }

    public String toString() {
        return Boolean.toString((Boolean)this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeBit(this.getClass().getSimpleName(), (Boolean)this.value, new WithWriterArgs[0]);
    }
}

