/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcCHAR
extends PlcIECValue<Short> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    public static final Short MIN_VALUE = 0;
    public static final Short MAX_VALUE = 255;

    public static PlcCHAR of(Object value) {
        if (value instanceof PlcCHAR) {
            return (PlcCHAR)value;
        }
        if (value instanceof Boolean) {
            return new PlcCHAR((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcCHAR((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcCHAR((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcCHAR((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcCHAR((Long)value);
        }
        if (value instanceof Float) {
            return new PlcCHAR((Float)value);
        }
        if (value instanceof Double) {
            return new PlcCHAR((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcCHAR((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcCHAR((BigDecimal)value);
        }
        if (value instanceof Character) {
            return new PlcCHAR((Character)value);
        }
        return new PlcCHAR(value.toString());
    }

    public PlcCHAR(Boolean value) {
        this.value = value != false ? (short)84 : 70;
        this.isNullable = false;
    }

    public PlcCHAR(Character value) {
        Integer val = value.charValue();
        if (val < MIN_VALUE || val > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = val.shortValue();
        this.isNullable = false;
    }

    public PlcCHAR(Byte value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcCHAR(Short value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcCHAR(Integer value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcCHAR(Long value) {
        if (value < (long)MIN_VALUE.shortValue() || value > (long)MAX_VALUE.shortValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcCHAR(Float value) {
        if (!(value.floatValue() >= (float)MIN_VALUE.shortValue()) || !(value.floatValue() <= (float)MAX_VALUE.shortValue())) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcCHAR(Double value) {
        if (!(value >= (double)MIN_VALUE.shortValue()) || !(value <= (double)MAX_VALUE.shortValue())) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcCHAR(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(MIN_VALUE.shortValue())) < 0 || value.compareTo(BigInteger.valueOf(MAX_VALUE.shortValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcCHAR(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(MIN_VALUE.shortValue())) < 0 || value.compareTo(BigDecimal.valueOf(MAX_VALUE.shortValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcCHAR(String value) {
        try {
            short val;
            String s = value.trim();
            if (s.length() == 0) {
                s = " ";
            }
            if ((val = (short)s.charAt(0)) < MIN_VALUE || val > MAX_VALUE) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
    }

    public PlcCHAR(short value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.CHAR;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Short)this.value).equals((short)0);
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Short)this.value <= 127 && (Short)this.value >= -128;
    }

    @Override
    public byte getByte() {
        return ((Short)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return true;
    }

    @Override
    public short getShort() {
        return (Short)this.value;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return ((Short)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return ((Short)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Short)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Short)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public Object getObject() {
        return Character.toString((char)((Short)this.value).shortValue());
    }

    public String toString() {
        return Character.toString((char)((Short)this.value).shortValue());
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Short)this.value & 0xFF)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((Short)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), 16, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

