/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcDATE
extends PlcIECValue<LocalDate> {
    public static PlcDATE of(Object value) {
        if (value instanceof PlcDATE) {
            return (PlcDATE)value;
        }
        if (value instanceof LocalDate) {
            return new PlcDATE((LocalDate)value);
        }
        if (value instanceof Byte) {
            return new PlcDATE((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcDATE((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcDATE((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcDATE((Long)value);
        }
        if (value instanceof Float) {
            return new PlcDATE((Float)value);
        }
        if (value instanceof Double) {
            return new PlcDATE((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcDATE((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcDATE((BigDecimal)value);
        }
        return new PlcDATE(LocalDate.parse(value.toString()));
    }

    public static PlcDATE ofSecondsSinceEpoch(long secondsSinceEpoch) {
        return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond(secondsSinceEpoch), ZoneOffset.UTC).toLocalDate());
    }

    public static PlcDATE ofDaysSinceEpoch(int daysSinceEpoch) {
        return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond((long)daysSinceEpoch * 86400L), ZoneOffset.UTC).toLocalDate());
    }

    public PlcDATE(LocalDate value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcDATE(Byte daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond((long)daysSinceEpoch.byteValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(Short daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond((long)daysSinceEpoch.shortValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(Integer daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond((long)daysSinceEpoch.intValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(Long daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond(daysSinceEpoch * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(Float daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond(daysSinceEpoch.longValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(Double daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond(daysSinceEpoch.longValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(BigInteger daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond(daysSinceEpoch.longValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcDATE(BigDecimal daysSinceEpoch) {
        this.value = LocalDateTime.ofInstant(Instant.ofEpochSecond(daysSinceEpoch.longValue() * 86400L), ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE;
    }

    public long getSecondsSinceEpoch() {
        return ((LocalDate)this.value).atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    }

    public int getDaysSinceEpoch() {
        return (int)(((LocalDate)this.value).atStartOfDay(ZoneOffset.UTC).toEpochSecond() / 86400L);
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDate)this.value).atStartOfDay(ZoneOffset.UTC).toInstant();
        return instant.toEpochMilli() / 1000L;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDate)this.value).toString();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return (LocalDate)this.value;
    }

    @Override
    public LocalDateTime getDateTime() {
        return ((LocalDate)this.value).atStartOfDay();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDate)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

