/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcTIME
extends PlcIECValue<Duration> {
    public static PlcTIME of(Object value) {
        if (value instanceof PlcTIME) {
            return (PlcTIME)value;
        }
        if (value instanceof Duration) {
            return new PlcTIME((Duration)value);
        }
        if (value instanceof Byte) {
            return new PlcTIME((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcTIME((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcTIME((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcTIME((Long)value);
        }
        if (value instanceof Float) {
            return new PlcTIME((Float)value);
        }
        if (value instanceof Double) {
            return new PlcTIME((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcTIME((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcTIME((BigDecimal)value);
        }
        return new PlcTIME(Duration.parse(value.toString()));
    }

    public static PlcTIME ofMilliseconds(long milliseconds) {
        return new PlcTIME(Duration.ofMillis(milliseconds));
    }

    public PlcTIME(Byte milliseconds) {
        this.value = Duration.ofMillis(milliseconds.byteValue());
        this.isNullable = false;
    }

    public PlcTIME(Short milliseconds) {
        this.value = Duration.ofMillis(milliseconds.shortValue());
        this.isNullable = false;
    }

    public PlcTIME(Integer milliseconds) {
        this.value = Duration.ofMillis(milliseconds.intValue());
        this.isNullable = false;
    }

    public PlcTIME(Long milliseconds) {
        this.value = Duration.ofMillis(milliseconds);
        this.isNullable = false;
    }

    public PlcTIME(Float milliseconds) {
        this.value = Duration.ofMillis(milliseconds.longValue());
        this.isNullable = false;
    }

    public PlcTIME(Double milliseconds) {
        this.value = Duration.ofMillis(milliseconds.longValue());
        this.isNullable = false;
    }

    public PlcTIME(BigInteger milliseconds) {
        this.value = Duration.ofMillis(milliseconds.longValue());
        this.isNullable = false;
    }

    public PlcTIME(BigDecimal milliseconds) {
        this.value = Duration.ofMillis(milliseconds.longValue());
        this.isNullable = false;
    }

    public PlcTIME(Duration value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.TIME;
    }

    public long getMilliseconds() {
        return ((Duration)this.value).toMillis();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return true;
    }

    @Override
    public int getInteger() {
        return (int)(((Duration)this.value).get(ChronoUnit.NANOS) / 1000000L);
    }

    @Override
    public long getLong() {
        return ((Duration)this.value).toMillis();
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.value;
    }

    @Override
    public String getString() {
        return ((Duration)this.value).toString();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeLong(this.getClass().getSimpleName(), 32, ((Duration)this.value).toMillis(), new WithWriterArgs[0]);
    }
}

