/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public abstract class PropertyNode<T extends PropertyNode<T>>
implements Comparable<T>,
Cloneable {
    private static final POILogger _logger = POILogFactory.getLogger(PropertyNode.class);
    protected Object _buf;
    private int _cpStart;
    private int _cpEnd;

    protected PropertyNode(int fcStart, int fcEnd, Object buf) {
        this._cpStart = fcStart;
        this._cpEnd = fcEnd;
        this._buf = buf;
        if (this._cpStart < 0) {
            _logger.log(5, (Object)("A property claimed to start before zero, at " + this._cpStart + "! Resetting it to zero, and hoping for the best"));
            this._cpStart = 0;
        }
        if (this._cpEnd < this._cpStart) {
            _logger.log(5, (Object)("A property claimed to end (" + this._cpEnd + ") before start! " + "Resetting end to start, and hoping for the best"));
            this._cpEnd = this._cpStart;
        }
    }

    public int getStart() {
        return this._cpStart;
    }

    public void setStart(int start) {
        this._cpStart = start;
    }

    public int getEnd() {
        return this._cpEnd;
    }

    public void setEnd(int end) {
        this._cpEnd = end;
    }

    public void adjustForDelete(int start, int length) {
        int end = start + length;
        if (this._cpEnd > start) {
            if (this._cpStart < end) {
                this._cpEnd = end >= this._cpEnd ? start : this._cpEnd - length;
                this._cpStart = Math.min(start, this._cpStart);
            } else {
                this._cpEnd -= length;
                this._cpStart -= length;
            }
        }
    }

    protected boolean limitsAreEqual(Object o) {
        return ((PropertyNode)o).getStart() == this._cpStart && ((PropertyNode)o).getEnd() == this._cpEnd;
    }

    public int hashCode() {
        return this._cpStart * 31 + this._buf.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PropertyNode)) {
            return false;
        }
        if (this.limitsAreEqual(o)) {
            Object testBuf = ((PropertyNode)o)._buf;
            if (testBuf instanceof byte[] && this._buf instanceof byte[]) {
                return Arrays.equals((byte[])testBuf, (byte[])this._buf);
            }
            return this._buf.equals(testBuf);
        }
        return false;
    }

    public T clone() throws CloneNotSupportedException {
        return (T)((PropertyNode)super.clone());
    }

    @Override
    public int compareTo(T o) {
        int cpEnd = ((PropertyNode)o).getEnd();
        if (this._cpEnd == cpEnd) {
            return 0;
        }
        if (this._cpEnd < cpEnd) {
            return -1;
        }
        return 1;
    }

    public static final class StartComparator
    implements Comparator<PropertyNode<?>> {
        public static final StartComparator instance = new StartComparator();

        @Override
        public int compare(PropertyNode<?> o1, PropertyNode<?> o2) {
            int anotherVal;
            int thisVal = o1.getStart();
            return thisVal < (anotherVal = o2.getStart()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }

    public static final class EndComparator
    implements Comparator<PropertyNode<?>> {
        public static final EndComparator instance = new EndComparator();

        @Override
        public int compare(PropertyNode<?> o1, PropertyNode<?> o2) {
            int anotherVal;
            int thisVal = o1.getEnd();
            return thisVal < (anotherVal = o2.getEnd()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

