/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfDraw;
import org.apache.poi.hwmf.record.HwmfFont;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordJsonWriter;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HwmfText {
    private static final POILogger logger = POILogFactory.getLogger(HwmfText.class);
    private static final int MAX_RECORD_LENGTH = 1000000;

    public static class WmfCreateFontIndirect
    implements HwmfRecord,
    HwmfObjectTableEntry {
        protected final HwmfFont font;

        public WmfCreateFontIndirect() {
            this(new HwmfFont());
        }

        protected WmfCreateFontIndirect(HwmfFont font) {
            this.font = font;
        }

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.createFontIndirect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return this.font.init(leis, recordSize);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            ctx.getProperties().setFont(this.font);
        }

        public HwmfFont getFont() {
            return this.font;
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"font", this::getFont);
        }
    }

    public static class WmfSetTextAlign
    implements HwmfRecord {
        private static final BitField TA_UPDATECP = BitFieldFactory.getInstance((int)1);
        private static final BitField TA_RTLREADING = BitFieldFactory.getInstance((int)256);
        private static final BitField ALIGN_MASK = BitFieldFactory.getInstance((int)6);
        private static final int ALIGN_LEFT = 0;
        private static final int ALIGN_RIGHT = 1;
        private static final int ALIGN_CENTER = 3;
        private static final BitField VALIGN_MASK = BitFieldFactory.getInstance((int)24);
        private static final int VALIGN_TOP = 0;
        private static final int VALIGN_BOTTOM = 1;
        private static final int VALIGN_BASELINE = 3;
        protected int textAlignmentMode;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setTextAlign;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.textAlignmentMode = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            HwmfDrawProperties props = ctx.getProperties();
            props.setTextAlignLatin(this.getAlignLatin());
            props.setTextVAlignLatin(this.getVAlignLatin());
            props.setTextAlignAsian(this.getAlignAsian());
            props.setTextVAlignAsian(this.getVAlignAsian());
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"align", this::getAlignLatin, (String)"valign", this::getVAlignLatin, (String)"alignAsian", this::getAlignAsian, (String)"valignAsian", this::getVAlignAsian);
        }

        private HwmfTextAlignment getAlignLatin() {
            switch (ALIGN_MASK.getValue(this.textAlignmentMode)) {
                default: {
                    return HwmfTextAlignment.LEFT;
                }
                case 3: {
                    return HwmfTextAlignment.CENTER;
                }
                case 1: 
            }
            return HwmfTextAlignment.RIGHT;
        }

        private HwmfTextVerticalAlignment getVAlignLatin() {
            switch (VALIGN_MASK.getValue(this.textAlignmentMode)) {
                default: {
                    return HwmfTextVerticalAlignment.TOP;
                }
                case 3: {
                    return HwmfTextVerticalAlignment.BASELINE;
                }
                case 1: 
            }
            return HwmfTextVerticalAlignment.BOTTOM;
        }

        private HwmfTextAlignment getAlignAsian() {
            switch (this.getVAlignLatin()) {
                default: {
                    return HwmfTextAlignment.RIGHT;
                }
                case BASELINE: {
                    return HwmfTextAlignment.CENTER;
                }
                case BOTTOM: 
            }
            return HwmfTextAlignment.LEFT;
        }

        private HwmfTextVerticalAlignment getVAlignAsian() {
            switch (this.getAlignLatin()) {
                default: {
                    return HwmfTextVerticalAlignment.TOP;
                }
                case CENTER: {
                    return HwmfTextVerticalAlignment.BASELINE;
                }
                case RIGHT: 
            }
            return HwmfTextVerticalAlignment.BOTTOM;
        }
    }

    public static enum HwmfTextVerticalAlignment {
        TOP,
        BOTTOM,
        BASELINE;

    }

    public static enum HwmfTextAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static class WmfExtTextOut
    implements HwmfRecord {
        protected final Point2D reference = new Point2D.Double();
        protected int stringLength;
        protected final WmfExtTextOutOptions options;
        protected final Rectangle2D bounds = new Rectangle2D.Double();
        protected byte[] rawTextBytes;
        protected final List<Integer> dx = new ArrayList<Integer>();

        public WmfExtTextOut() {
            this(new WmfExtTextOutOptions());
        }

        protected WmfExtTextOut(WmfExtTextOutOptions options) {
            this.options = options;
        }

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.extTextOut;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int remainingRecordSize = (int)(recordSize - 6L);
            int size = HwmfDraw.readPointS(leis, this.reference);
            this.stringLength = leis.readShort();
            size += 2;
            if ((this.options.isOpaque() || this.options.isClipped()) && (size += this.options.init(leis)) + 8 <= remainingRecordSize) {
                size += HwmfDraw.readRectS(leis, this.bounds);
            }
            this.rawTextBytes = IOUtils.safelyAllocate((long)(this.stringLength + (this.stringLength & 1)), (int)1000000);
            leis.readFully(this.rawTextBytes);
            if ((size += this.rawTextBytes.length) >= remainingRecordSize) {
                logger.log(3, new Object[]{"META_EXTTEXTOUT doesn't contain character tracking info"});
                return size;
            }
            int dxLen = Math.min(this.stringLength, (remainingRecordSize - size) / 2);
            if (dxLen < this.stringLength) {
                logger.log(5, new Object[]{"META_EXTTEXTOUT tracking info doesn't cover all characters"});
            }
            for (int i = 0; i < dxLen; ++i) {
                this.dx.add(Integer.valueOf(leis.readShort()));
                size += 2;
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.drawString(this.rawTextBytes, this.stringLength, this.reference, null, this.bounds, this.options, this.dx, false);
        }

        public String getText(Charset charset) throws IOException {
            if (this.rawTextBytes == null) {
                return "";
            }
            String ret = new String(this.rawTextBytes, charset);
            return ret.substring(0, Math.min(ret.length(), this.stringLength));
        }

        public Point2D getReference() {
            return this.reference;
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        protected boolean isUnicode() {
            return false;
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        private String getGenericText() {
            try {
                return this.getText(this.isUnicode() ? StandardCharsets.UTF_16LE : StandardCharsets.US_ASCII);
            }
            catch (IOException e) {
                return "";
            }
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"reference", this::getReference, (String)"bounds", this::getBounds, (String)"text", this::getGenericText);
        }
    }

    public static class WmfExtTextOutOptions
    implements GenericRecord {
        private static final BitField ETO_OPAQUE = BitFieldFactory.getInstance((int)2);
        private static final BitField ETO_CLIPPED = BitFieldFactory.getInstance((int)4);
        private static final BitField ETO_GLYPH_INDEX = BitFieldFactory.getInstance((int)16);
        private static final BitField ETO_RTLREADING = BitFieldFactory.getInstance((int)128);
        private static final BitField ETO_NO_RECT = BitFieldFactory.getInstance((int)256);
        private static final BitField ETO_SMALL_CHARS = BitFieldFactory.getInstance((int)512);
        private static final BitField ETO_NUMERICSLOCAL = BitFieldFactory.getInstance((int)1024);
        private static final BitField ETO_NUMERICSLATIN = BitFieldFactory.getInstance((int)2048);
        private static final BitField ETO_IGNORELANGUAGE = BitFieldFactory.getInstance((int)4096);
        private static final BitField ETO_PDY = BitFieldFactory.getInstance((int)8192);
        private static final BitField ETO_REVERSE_INDEX_MAP = BitFieldFactory.getInstance((int)65536);
        private static final int[] FLAGS_MASKS = new int[]{2, 4, 16, 128, 256, 512, 1024, 2048, 4096, 8192, 65536};
        private static final String[] FLAGS_NAMES = new String[]{"OPAQUE", "CLIPPED", "GLYPH_INDEX", "RTLREADING", "NO_RECT", "SMALL_CHARS", "NUMERICSLOCAL", "NUMERICSLATIN", "IGNORELANGUAGE", "PDY", "REVERSE_INDEX_MAP"};
        protected int flags;

        public int init(LittleEndianInputStream leis) {
            this.flags = leis.readUShort();
            return 2;
        }

        public boolean isOpaque() {
            return ETO_OPAQUE.isSet(this.flags);
        }

        public boolean isClipped() {
            return ETO_CLIPPED.isSet(this.flags);
        }

        public boolean isYDisplaced() {
            return ETO_PDY.isSet(this.flags);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", (Supplier)GenericRecordUtil.getBitsAsString(() -> this.flags, (int[])FLAGS_MASKS, (String[])FLAGS_NAMES));
        }
    }

    public static class WmfTextOut
    implements HwmfRecord {
        private int stringLength;
        private byte[] rawTextBytes;
        protected Point2D reference = new Point2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.textOut;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.stringLength = leis.readShort();
            this.rawTextBytes = IOUtils.safelyAllocate((long)(this.stringLength + (this.stringLength & 1)), (int)1000000);
            leis.readFully(this.rawTextBytes);
            short yStart = leis.readShort();
            short xStart = leis.readShort();
            this.reference.setLocation(xStart, yStart);
            return 6 + this.rawTextBytes.length;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.drawString(this.getTextBytes(), this.stringLength, this.reference);
        }

        public String getText(Charset charset) {
            return new String(this.getTextBytes(), charset);
        }

        private byte[] getTextBytes() {
            byte[] ret = IOUtils.safelyAllocate((long)this.stringLength, (int)1000000);
            System.arraycopy(this.rawTextBytes, 0, ret, 0, this.stringLength);
            return ret;
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"text", () -> this.getText(StandardCharsets.US_ASCII));
        }
    }

    public static class WmfSetTextJustification
    implements HwmfRecord {
        private int breakCount;
        private int breakExtra;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setBkColor;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.breakCount = leis.readUShort();
            this.breakExtra = leis.readUShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"breakCount", () -> this.breakCount, (String)"breakExtra", () -> this.breakExtra);
        }
    }

    public static class WmfSetTextColor
    implements HwmfRecord {
        protected final HwmfColorRef colorRef = new HwmfColorRef();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setTextColor;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return this.colorRef.init(leis);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setTextColor(this.colorRef);
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public HwmfColorRef getColorRef() {
            return this.colorRef;
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"colorRef", this::getColorRef);
        }
    }

    public static class WmfSetTextCharExtra
    implements HwmfRecord {
        private int charExtra;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setTextCharExtra;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.charExtra = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"charExtra", () -> this.charExtra);
        }
    }
}

