/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.demo.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSODemoServlet
extends HttpServlet {
    public static final String DEMO_SSO_PRINCIPAL_PARAM = "sso-principal";
    public static final String DEMO_SSO_CREDENTIAL_PARAM = "sso-credential";
    public static final String DEMO_SSO_CREDENTIAL = "secret-password";

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String principal = request.getParameter(DEMO_SSO_PRINCIPAL_PARAM);
        String credential = request.getParameter(DEMO_SSO_CREDENTIAL_PARAM);
        String authenticatedPrincipal = "007";
        if (principal == null) {
            this.error403(request, response, "SSO Principal is not valid. Please provide a valid SSO principal.");
            return;
        }
        if (credential == null) {
            this.error403(request, response, "SSO Credential is not valid. Please provide a valid SSO credential.");
            return;
        }
        if (!principal.equals(authenticatedPrincipal)) {
            this.error403(request, response, "SSO Principal not found on SSO Server. Please provide a valid SSO principal.");
            return;
        }
        if (!credential.equals(DEMO_SSO_CREDENTIAL)) {
            this.error403(request, response, "SSO Credential does not match. Please provide a valid SSO credential.");
            return;
        }
        response.getWriter().println("<b>Welcome to the SSO Gateway!</b><br/>");
        response.getWriter().println("Remote Principal has been authenticated.<br/>");
        response.getWriter().println("Remote User  = " + authenticatedPrincipal + "<br/>");
    }

    private void error403(HttpServletRequest request, HttpServletResponse response, String message) throws IOException, ServletException {
        response.getWriter().println("<b>HTTP Status 403: Access to SSO Demo Site not permitted.<br/>");
        response.getWriter().println(message + "<br/>");
        response.getWriter().println("To configure the SSO Principal, switch to Edit Mode.<br/>");
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }
}

