/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SQLScriptReader {
    private static final String EOL = System.getProperty("line.separator");
    private BufferedReader reader;

    public SQLScriptReader(InputStream scriptStream) throws FileNotFoundException {
        this.reader = new BufferedReader(new InputStreamReader(scriptStream));
    }

    public SQLScriptReader(File scriptFile) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(scriptFile));
    }

    public String readSQLStatement() throws IOException {
        StringBuilder sqlStatement;
        block4: {
            String line;
            sqlStatement = new StringBuilder();
            boolean comment = false;
            while ((line = this.reader.readLine()) != null) {
                line = line.trim();
                if (comment) {
                    comment = !line.endsWith("*/");
                    continue;
                }
                comment = line.startsWith("/*");
                if (comment || line.startsWith("--") || line.startsWith("//") || line.startsWith("#") || line.length() <= 0) continue;
                if (sqlStatement.length() > 0) {
                    sqlStatement.append(EOL);
                }
                if (line.endsWith(";")) {
                    sqlStatement.append(line.substring(0, line.length() - 1));
                    break block4;
                }
                sqlStatement.append(line);
            }
            sqlStatement.setLength(0);
        }
        return sqlStatement.length() > 0 ? sqlStatement.toString() : null;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

