/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import org.apache.pulsar.tests.BetweenTestClassesListenerAdapter;
import org.apache.pulsar.tests.FastThreadLocalStateCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastThreadLocalCleanupListener
extends BetweenTestClassesListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FastThreadLocalCleanupListener.class);
    private static final boolean FAST_THREAD_LOCAL_CLEANUP_ENABLED = Boolean.valueOf(System.getProperty("testFastThreadLocalCleanup", "true"));
    private static final String FAST_THREAD_LOCAL_CLEANUP_PACKAGE = System.getProperty("testFastThreadLocalCleanupPackage", "org.apache.pulsar");
    private static final FastThreadLocalStateCleaner CLEANER = new FastThreadLocalStateCleaner(object -> {
        Package pkg;
        if ("*".equals(FAST_THREAD_LOCAL_CLEANUP_PACKAGE)) {
            return true;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if ((pkg = clazz.getPackage()) != null && pkg.getName() != null) {
            return pkg.getName().startsWith(FAST_THREAD_LOCAL_CLEANUP_PACKAGE);
        }
        return false;
    });

    @Override
    protected void onBetweenTestClasses(Class<?> endedTestClass, Class<?> startedTestClass) {
        if (FAST_THREAD_LOCAL_CLEANUP_ENABLED && FastThreadLocalStateCleaner.isEnabled()) {
            LOG.info("Cleaning up FastThreadLocal thread local state.");
            CLEANER.cleanupAllFastThreadLocals((thread, value) -> LOG.info("Cleaning FastThreadLocal state for thread {}, instance of class {}, value is {}", new Object[]{thread, value.getClass().getName(), value}));
        }
    }
}

