/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.functions;

import java.util.Arrays;
import java.util.Map;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;

public class CryptoConfig {
    private String cryptoKeyReaderClassName;
    private Map<String, Object> cryptoKeyReaderConfig;
    private String[] encryptionKeys;
    private ProducerCryptoFailureAction producerCryptoFailureAction;
    private ConsumerCryptoFailureAction consumerCryptoFailureAction;

    public static CryptoConfigBuilder builder() {
        return new CryptoConfigBuilder();
    }

    public String getCryptoKeyReaderClassName() {
        return this.cryptoKeyReaderClassName;
    }

    public Map<String, Object> getCryptoKeyReaderConfig() {
        return this.cryptoKeyReaderConfig;
    }

    public String[] getEncryptionKeys() {
        return this.encryptionKeys;
    }

    public ProducerCryptoFailureAction getProducerCryptoFailureAction() {
        return this.producerCryptoFailureAction;
    }

    public ConsumerCryptoFailureAction getConsumerCryptoFailureAction() {
        return this.consumerCryptoFailureAction;
    }

    public void setCryptoKeyReaderClassName(String cryptoKeyReaderClassName) {
        this.cryptoKeyReaderClassName = cryptoKeyReaderClassName;
    }

    public void setCryptoKeyReaderConfig(Map<String, Object> cryptoKeyReaderConfig) {
        this.cryptoKeyReaderConfig = cryptoKeyReaderConfig;
    }

    public void setEncryptionKeys(String[] encryptionKeys) {
        this.encryptionKeys = encryptionKeys;
    }

    public void setProducerCryptoFailureAction(ProducerCryptoFailureAction producerCryptoFailureAction) {
        this.producerCryptoFailureAction = producerCryptoFailureAction;
    }

    public void setConsumerCryptoFailureAction(ConsumerCryptoFailureAction consumerCryptoFailureAction) {
        this.consumerCryptoFailureAction = consumerCryptoFailureAction;
    }

    public String toString() {
        return "CryptoConfig(cryptoKeyReaderClassName=" + this.getCryptoKeyReaderClassName() + ", cryptoKeyReaderConfig=" + this.getCryptoKeyReaderConfig() + ", encryptionKeys=" + Arrays.deepToString(this.getEncryptionKeys()) + ", producerCryptoFailureAction=" + this.getProducerCryptoFailureAction() + ", consumerCryptoFailureAction=" + this.getConsumerCryptoFailureAction() + ")";
    }

    public CryptoConfig() {
    }

    public CryptoConfig(String cryptoKeyReaderClassName, Map<String, Object> cryptoKeyReaderConfig, String[] encryptionKeys, ProducerCryptoFailureAction producerCryptoFailureAction, ConsumerCryptoFailureAction consumerCryptoFailureAction) {
        this.cryptoKeyReaderClassName = cryptoKeyReaderClassName;
        this.cryptoKeyReaderConfig = cryptoKeyReaderConfig;
        this.encryptionKeys = encryptionKeys;
        this.producerCryptoFailureAction = producerCryptoFailureAction;
        this.consumerCryptoFailureAction = consumerCryptoFailureAction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptoConfig)) {
            return false;
        }
        CryptoConfig other = (CryptoConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cryptoKeyReaderClassName = this.getCryptoKeyReaderClassName();
        String other$cryptoKeyReaderClassName = other.getCryptoKeyReaderClassName();
        if (this$cryptoKeyReaderClassName == null ? other$cryptoKeyReaderClassName != null : !this$cryptoKeyReaderClassName.equals(other$cryptoKeyReaderClassName)) {
            return false;
        }
        Map<String, Object> this$cryptoKeyReaderConfig = this.getCryptoKeyReaderConfig();
        Map<String, Object> other$cryptoKeyReaderConfig = other.getCryptoKeyReaderConfig();
        if (this$cryptoKeyReaderConfig == null ? other$cryptoKeyReaderConfig != null : !((Object)this$cryptoKeyReaderConfig).equals(other$cryptoKeyReaderConfig)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEncryptionKeys(), other.getEncryptionKeys())) {
            return false;
        }
        ProducerCryptoFailureAction this$producerCryptoFailureAction = this.getProducerCryptoFailureAction();
        ProducerCryptoFailureAction other$producerCryptoFailureAction = other.getProducerCryptoFailureAction();
        if (this$producerCryptoFailureAction == null ? other$producerCryptoFailureAction != null : !this$producerCryptoFailureAction.equals(other$producerCryptoFailureAction)) {
            return false;
        }
        ConsumerCryptoFailureAction this$consumerCryptoFailureAction = this.getConsumerCryptoFailureAction();
        ConsumerCryptoFailureAction other$consumerCryptoFailureAction = other.getConsumerCryptoFailureAction();
        return !(this$consumerCryptoFailureAction == null ? other$consumerCryptoFailureAction != null : !this$consumerCryptoFailureAction.equals(other$consumerCryptoFailureAction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cryptoKeyReaderClassName = this.getCryptoKeyReaderClassName();
        result = result * 59 + ($cryptoKeyReaderClassName == null ? 43 : $cryptoKeyReaderClassName.hashCode());
        Map<String, Object> $cryptoKeyReaderConfig = this.getCryptoKeyReaderConfig();
        result = result * 59 + ($cryptoKeyReaderConfig == null ? 43 : ((Object)$cryptoKeyReaderConfig).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEncryptionKeys());
        ProducerCryptoFailureAction $producerCryptoFailureAction = this.getProducerCryptoFailureAction();
        result = result * 59 + ($producerCryptoFailureAction == null ? 43 : $producerCryptoFailureAction.hashCode());
        ConsumerCryptoFailureAction $consumerCryptoFailureAction = this.getConsumerCryptoFailureAction();
        result = result * 59 + ($consumerCryptoFailureAction == null ? 43 : $consumerCryptoFailureAction.hashCode());
        return result;
    }

    public static class CryptoConfigBuilder {
        private String cryptoKeyReaderClassName;
        private Map<String, Object> cryptoKeyReaderConfig;
        private String[] encryptionKeys;
        private ProducerCryptoFailureAction producerCryptoFailureAction;
        private ConsumerCryptoFailureAction consumerCryptoFailureAction;

        CryptoConfigBuilder() {
        }

        public CryptoConfigBuilder cryptoKeyReaderClassName(String cryptoKeyReaderClassName) {
            this.cryptoKeyReaderClassName = cryptoKeyReaderClassName;
            return this;
        }

        public CryptoConfigBuilder cryptoKeyReaderConfig(Map<String, Object> cryptoKeyReaderConfig) {
            this.cryptoKeyReaderConfig = cryptoKeyReaderConfig;
            return this;
        }

        public CryptoConfigBuilder encryptionKeys(String[] encryptionKeys) {
            this.encryptionKeys = encryptionKeys;
            return this;
        }

        public CryptoConfigBuilder producerCryptoFailureAction(ProducerCryptoFailureAction producerCryptoFailureAction) {
            this.producerCryptoFailureAction = producerCryptoFailureAction;
            return this;
        }

        public CryptoConfigBuilder consumerCryptoFailureAction(ConsumerCryptoFailureAction consumerCryptoFailureAction) {
            this.consumerCryptoFailureAction = consumerCryptoFailureAction;
            return this;
        }

        public CryptoConfig build() {
            return new CryptoConfig(this.cryptoKeyReaderClassName, this.cryptoKeyReaderConfig, this.encryptionKeys, this.producerCryptoFailureAction, this.consumerCryptoFailureAction);
        }

        public String toString() {
            return "CryptoConfig.CryptoConfigBuilder(cryptoKeyReaderClassName=" + this.cryptoKeyReaderClassName + ", cryptoKeyReaderConfig=" + this.cryptoKeyReaderConfig + ", encryptionKeys=" + Arrays.deepToString(this.encryptionKeys) + ", producerCryptoFailureAction=" + this.producerCryptoFailureAction + ", consumerCryptoFailureAction=" + this.consumerCryptoFailureAction + ")";
        }
    }
}

