/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.NonPersistentTopics;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class NonPersistentTopicsImpl
extends BaseResource
implements NonPersistentTopics {
    private final WebTarget adminNonPersistentTopics;
    private final WebTarget adminV2NonPersistentTopics;

    public NonPersistentTopicsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminNonPersistentTopics = web.path("/admin");
        this.adminV2NonPersistentTopics = web.path("/admin/v2");
    }

    public void createPartitionedTopic(String topic, int numPartitions) throws PulsarAdminException {
        this.sync(() -> this.createPartitionedTopicAsync(topic, numPartitions));
    }

    public CompletableFuture<Void> createPartitionedTopicAsync(String topic, int numPartitions) {
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions should be more than 0");
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "partitions");
        return this.asyncPutRequest(path, Entity.entity(Integer.valueOf(numPartitions), "application/json"));
    }

    public PartitionedTopicMetadata getPartitionedTopicMetadata(String topic) throws PulsarAdminException {
        return (PartitionedTopicMetadata)this.sync(() -> this.getPartitionedTopicMetadataAsync(topic));
    }

    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        final CompletableFuture<PartitionedTopicMetadata> future = new CompletableFuture<PartitionedTopicMetadata>();
        WebTarget path = this.topicPath(topicName, "partitions");
        this.asyncGetRequest(path, new InvocationCallback<PartitionedTopicMetadata>(){

            @Override
            public void completed(PartitionedTopicMetadata response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NonPersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public NonPersistentTopicStats getStats(String topic) throws PulsarAdminException {
        return (NonPersistentTopicStats)this.sync(() -> this.getStatsAsync(topic));
    }

    public CompletableFuture<NonPersistentTopicStats> getStatsAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        final CompletableFuture<NonPersistentTopicStats> future = new CompletableFuture<NonPersistentTopicStats>();
        WebTarget path = this.topicPath(topicName, "stats");
        this.asyncGetRequest(path, new InvocationCallback<NonPersistentTopicStats>(){

            @Override
            public void completed(NonPersistentTopicStats response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NonPersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public PersistentTopicInternalStats getInternalStats(String topic) throws PulsarAdminException {
        return (PersistentTopicInternalStats)this.sync(() -> this.getInternalStatsAsync(topic));
    }

    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        final CompletableFuture<PersistentTopicInternalStats> future = new CompletableFuture<PersistentTopicInternalStats>();
        WebTarget path = this.topicPath(topicName, "internalStats");
        this.asyncGetRequest(path, new InvocationCallback<PersistentTopicInternalStats>(){

            @Override
            public void completed(PersistentTopicInternalStats response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NonPersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void unload(String topic) throws PulsarAdminException {
        this.sync(() -> this.unloadAsync(topic));
    }

    public CompletableFuture<Void> unloadAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public List<String> getListInBundle(String namespace, String bundleRange) throws PulsarAdminException {
        return (List)this.sync(() -> this.getListInBundleAsync(namespace, bundleRange));
    }

    public CompletableFuture<List<String>> getListInBundleAsync(String namespace, String bundleRange) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        WebTarget path = this.namespacePath("non-persistent", ns, bundleRange);
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NonPersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<String> getList(String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getListAsync(namespace));
    }

    public CompletableFuture<List<String>> getListAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        WebTarget path = this.namespacePath("non-persistent", ns, new String[0]);
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NonPersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    private TopicName validateTopic(String topic) {
        return TopicName.get(topic);
    }

    private WebTarget namespacePath(String domain, NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2NonPersistentTopics : this.adminNonPersistentTopics;
        WebTarget namespacePath = base.path(domain).path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2NonPersistentTopics : this.adminNonPersistentTopics;
        WebTarget topicPath = base.path(topic.getRestPath());
        topicPath = WebTargets.addParts(topicPath, parts);
        return topicPath;
    }
}

