/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Map;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.client.impl.schema.reader.JsonReader;
import org.apache.pulsar.client.impl.schema.writer.JsonWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSchema<T>
extends StructSchema<T> {
    private static final Logger log = LoggerFactory.getLogger(JSONSchema.class);
    private static final ThreadLocal<ObjectMapper> JSON_MAPPER = ThreadLocal.withInitial(() -> {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    });
    private final Class<T> pojo;

    private JSONSchema(SchemaInfo schemaInfo, Class<T> pojo) {
        super(schemaInfo);
        this.pojo = pojo;
        this.setWriter(new JsonWriter(JSON_MAPPER.get()));
        this.setReader(new JsonReader<T>(JSON_MAPPER.get(), pojo));
    }

    @Override
    protected SchemaReader<T> loadReader(byte[] schemaVersion) {
        throw new RuntimeException("JSONSchema don't support schema versioning");
    }

    public SchemaInfo getBackwardsCompatibleJsonSchemaInfo() {
        SchemaInfo backwardsCompatibleSchemaInfo;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(objectMapper);
            JsonSchema jsonBackwardsCompatibleSchema = schemaGen.generateSchema(this.pojo);
            backwardsCompatibleSchemaInfo = new SchemaInfo();
            backwardsCompatibleSchemaInfo.setName("");
            backwardsCompatibleSchemaInfo.setProperties(this.schemaInfo.getProperties());
            backwardsCompatibleSchemaInfo.setType(SchemaType.JSON);
            backwardsCompatibleSchemaInfo.setSchema(objectMapper.writeValueAsBytes(jsonBackwardsCompatibleSchema));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return backwardsCompatibleSchemaInfo;
    }

    public static <T> JSONSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        return new JSONSchema<T>(JSONSchema.parseSchemaInfo(schemaDefinition, SchemaType.JSON), schemaDefinition.getPojo());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo) {
        return JSONSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return JSONSchema.of(SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build());
    }
}

