/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.writer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaWriter;

public class AvroWriter<T>
implements SchemaWriter<T> {
    private final ReflectDatumWriter<T> writer;
    private BinaryEncoder encoder;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    public AvroWriter(Schema schema) {
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.byteArrayOutputStream, this.encoder);
        this.writer = new ReflectDatumWriter(schema);
    }

    public synchronized byte[] write(T message) {
        try {
            this.writer.write(message, (Encoder)this.encoder);
            this.encoder.flush();
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SchemaSerializationException((Throwable)e);
        }
        finally {
            this.byteArrayOutputStream.reset();
        }
    }
}

