/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.util.List;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Source;
import org.apache.pulsar.client.admin.Sources;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcesImpl
extends ComponentResource
implements Sources,
Source {
    private static final Logger log = LoggerFactory.getLogger(SourcesImpl.class);
    private final WebTarget source;
    private final AsyncHttpClient asyncHttpClient;

    public SourcesImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.source = web.path("/admin/v3/source");
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public List<String> listSources(String tenant, String namespace) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.source.path(tenant).path(namespace)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SourceConfig getSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.source.path(tenant).path(namespace).path(sourceName)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(SourceConfig.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SourceStatus getSourceStatus(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.source.path(tenant).path(namespace).path(sourceName).path("status")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(SourceStatus.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData getSourceStatus(String tenant, String namespace, String sourceName, int id) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(id)).path("status")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(SourceStatus.SourceInstanceStatus.SourceInstanceStatusData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createSource(SourceConfig sourceConfig, String fileName) throws PulsarAdminException {
        try {
            Response response;
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sourceConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sourceConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            if ((response = (Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.source, builder).build()).get()).getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(org.apache.pulsar.shade.javax.ws.rs.core.Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createSourceWithUrl(SourceConfig sourceConfig, String pkgUrl) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sourceConfig", (Object)new Gson().toJson(sourceConfig), MediaType.APPLICATION_JSON_TYPE));
            this.request(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName())).post(Entity.entity(mp, "multipart/form-data"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteSource(String cluster, String namespace, String function) throws PulsarAdminException {
        try {
            this.request(this.source.path(cluster).path(namespace).path(function)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateSource(SourceConfig sourceConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            Response response;
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sourceConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sourceConfig), "application/json"));
            if (updateOptions != null) {
                builder.addBodyPart(new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            if ((response = (Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.source, builder).build()).get()).getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(org.apache.pulsar.shade.javax.ws.rs.core.Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateSource(SourceConfig sourceConfig, String fileName) throws PulsarAdminException {
        this.updateSource(sourceConfig, fileName, null);
    }

    @Override
    public void updateSourceWithUrl(SourceConfig sourceConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sourceConfig", (Object)new Gson().toJson(sourceConfig), MediaType.APPLICATION_JSON_TYPE));
            if (updateOptions != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), MediaType.APPLICATION_JSON_TYPE));
            }
            this.request(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName())).put(Entity.entity(mp, "multipart/form-data"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateSourceWithUrl(SourceConfig sourceConfig, String pkgUrl) throws PulsarAdminException {
        this.updateSourceWithUrl(sourceConfig, pkgUrl, null);
    }

    @Override
    public void restartSource(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.source.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("restart")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void restartSource(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.request(this.source.path(tenant).path(namespace).path(functionName).path("restart")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void stopSource(String tenant, String namespace, String sourceName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(instanceId)).path("stop")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void stopSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            this.request(this.source.path(tenant).path(namespace).path(sourceName).path("stop")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void startSource(String tenant, String namespace, String sourceName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(instanceId)).path("start")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void startSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            this.request(this.source.path(tenant).path(namespace).path(sourceName).path("start")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<ConnectorDefinition> getBuiltInSources() throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.source.path("builtinsources")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<ConnectorDefinition>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void reloadBuiltInSources() throws PulsarAdminException {
        try {
            this.request(this.source.path("reloadBuiltInSources")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

