/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class AutoProduceBytesSchema<T>
implements Schema<byte[]> {
    private boolean requireSchemaValidation = true;
    private Schema<T> schema;

    public AutoProduceBytesSchema() {
    }

    public AutoProduceBytesSchema(Schema<T> schema) {
        this.schema = schema;
        SchemaInfo schemaInfo = schema.getSchemaInfo();
        this.requireSchemaValidation = schemaInfo != null && schemaInfo.getType() != SchemaType.BYTES && schemaInfo.getType() != SchemaType.NONE;
    }

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
        this.requireSchemaValidation = schema.getSchemaInfo() != null && SchemaType.BYTES != schema.getSchemaInfo().getType() && SchemaType.NONE != schema.getSchemaInfo().getType();
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(this.schemaInitialized(), "Schema is not initialized before used");
    }

    public boolean schemaInitialized() {
        return this.schema != null;
    }

    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            if (this.schema instanceof KeyValueSchema && ((KeyValueSchema)this.schema).getKeyValueEncodingType().equals((Object)KeyValueEncodingType.SEPARATED)) {
                ((KeyValueSchema)this.schema).getValueSchema().validate(message);
            } else {
                this.schema.validate(message);
            }
        }
        return message;
    }

    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.decode(bytes, schemaVersion);
        }
        return bytes;
    }

    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }

    public Optional<Object> getNativeSchema() {
        return Optional.ofNullable(this.schema).map(s -> s.getNativeSchema()).orElse(Optional.empty());
    }

    public Schema<byte[]> clone() {
        return new AutoProduceBytesSchema<T>(this.schema.clone());
    }
}

