/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.impl.schema.generic.VersionedGenericRecord;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJsonRecord
extends VersionedGenericRecord {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericJsonRecord.class);
    private final JsonNode jn;
    private final SchemaInfo schemaInfo;

    GenericJsonRecord(byte[] schemaVersion, List<Field> fields, JsonNode jn) {
        this(schemaVersion, fields, jn, null);
    }

    public GenericJsonRecord(byte[] schemaVersion, List<Field> fields, JsonNode jn, SchemaInfo schemaInfo) {
        super(schemaVersion, fields);
        this.jn = jn;
        this.schemaInfo = schemaInfo;
    }

    public JsonNode getJsonNode() {
        return this.jn;
    }

    public Object getField(String fieldName) {
        JsonNode fn = this.jn.get(fieldName);
        if (fn == null) {
            return null;
        }
        if (fn.isContainerNode()) {
            AtomicInteger idx = new AtomicInteger(0);
            List<Field> fields = Lists.newArrayList(fn.fieldNames()).stream().map(f -> new Field(f, idx.getAndIncrement())).collect(Collectors.toList());
            return new GenericJsonRecord(this.schemaVersion, fields, fn, this.schemaInfo);
        }
        if (fn.isBoolean()) {
            return fn.asBoolean();
        }
        if (fn.isFloatingPointNumber()) {
            return fn.asDouble();
        }
        if (fn.isBigInteger()) {
            if (fn.canConvertToLong()) {
                return fn.asLong();
            }
            return fn.asText();
        }
        if (fn.isNumber()) {
            return fn.numberValue();
        }
        if (fn.isBinary()) {
            try {
                return fn.binaryValue();
            }
            catch (IOException e) {
                return fn.asText();
            }
        }
        if (this.isBinaryValue(fieldName)) {
            try {
                return fn.binaryValue();
            }
            catch (IOException e) {
                return fn.asText();
            }
        }
        if (fn.isNull()) {
            return null;
        }
        return fn.asText();
    }

    private boolean isBinaryValue(String fieldName) {
        if (this.schemaInfo == null) {
            return false;
        }
        boolean isBinary = false;
        try {
            Schema schema = GenericJsonRecord.parseAvroSchema(this.schemaInfo.getSchemaDefinition());
            Schema.Field field = schema.getField(fieldName);
            if (field == null) {
                return false;
            }
            JsonNode jsonNode = ObjectMapperFactory.getMapper().reader().readTree(field.schema().toString());
            for (JsonNode node : jsonNode) {
                JsonNode jn = node.get("type");
                if (jn == null || !"bytes".equals(jn.asText()) && !"byte".equals(jn.asText())) continue;
                isBinary = true;
                break;
            }
        }
        catch (Exception e) {
            log.error("parse schemaInfo failed. ", (Throwable)e);
        }
        return isBinary;
    }

    private static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public Object getNativeObject() {
        return this.jn;
    }

    public SchemaType getSchemaType() {
        return SchemaType.JSON;
    }
}

