/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.impl;

import java.util.function.Consumer;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.impl.ByteBufAllocatorImpl;

public class ByteBufAllocatorBuilderImpl
implements ByteBufAllocatorBuilder {
    ByteBufAllocator pooledAllocator = null;
    ByteBufAllocator unpooledAllocator = null;
    PoolingPolicy poolingPolicy = PoolingPolicy.PooledDirect;
    int poolingConcurrency = 2 * Runtime.getRuntime().availableProcessors();
    OutOfMemoryPolicy outOfMemoryPolicy = OutOfMemoryPolicy.FallbackToHeap;
    Consumer<OutOfMemoryError> outOfMemoryListener = null;
    LeakDetectionPolicy leakDetectionPolicy = LeakDetectionPolicy.Disabled;
    boolean exitOnOutOfMemory = false;

    @Override
    public ByteBufAllocatorWithOomHandler build() {
        return new ByteBufAllocatorImpl(this.pooledAllocator, this.unpooledAllocator, this.poolingPolicy, this.poolingConcurrency, this.outOfMemoryPolicy, this.outOfMemoryListener, this.leakDetectionPolicy, this.exitOnOutOfMemory);
    }

    @Override
    public ByteBufAllocatorBuilder pooledAllocator(ByteBufAllocator pooledAllocator) {
        this.pooledAllocator = pooledAllocator;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder unpooledAllocator(ByteBufAllocator unpooledAllocator) {
        this.unpooledAllocator = unpooledAllocator;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder poolingPolicy(PoolingPolicy policy) {
        this.poolingPolicy = policy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder poolingConcurrency(int poolingConcurrency) {
        this.poolingConcurrency = poolingConcurrency;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder outOfMemoryPolicy(OutOfMemoryPolicy policy) {
        this.outOfMemoryPolicy = policy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder outOfMemoryListener(Consumer<OutOfMemoryError> listener) {
        this.outOfMemoryListener = listener;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder leakDetectionPolicy(LeakDetectionPolicy leakDetectionPolicy) {
        this.leakDetectionPolicy = leakDetectionPolicy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder exitOnOutOfMemory(boolean exitOnOutOfMemory) {
        this.exitOnOutOfMemory = exitOnOutOfMemory;
        return this;
    }
}

