/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.Objects;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.common.protocol.schema.SchemaHash;

final class ProducerCacheKey {
    private final PulsarClient pulsarClient;
    private final ProducerConfigurationData producerConfigurationData;
    private final Schema<?> schema;
    private final SchemaHash schemaHash;
    private final Object producerActionTransformerKey;

    ProducerCacheKey(PulsarClient pulsarClient, ProducerConfigurationData producerConfigurationData, Schema<?> schema, Object producerActionTransformerKey) {
        this.pulsarClient = pulsarClient;
        this.producerConfigurationData = producerConfigurationData;
        this.schema = schema;
        this.schemaHash = this.schema != null ? SchemaHash.of(this.schema) : null;
        this.producerActionTransformerKey = producerActionTransformerKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProducerCacheKey that = (ProducerCacheKey)o;
        return Objects.equals(this.pulsarClient, that.pulsarClient) && Objects.equals(this.producerConfigurationData, that.producerConfigurationData) && Objects.equals(this.schemaHash, that.schemaHash) && Objects.equals(this.producerActionTransformerKey, that.producerActionTransformerKey);
    }

    public int hashCode() {
        return Objects.hash(this.pulsarClient, this.producerConfigurationData, this.schemaHash, this.producerActionTransformerKey);
    }

    public String toString() {
        return "ProducerCacheKey{pulsarClient=" + this.pulsarClient + ", producerConfigurationData=" + this.producerConfigurationData + ", schema=" + this.schema + ", producerActionTransformerKey=" + this.producerActionTransformerKey + "}";
    }
}

