/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.common.base.Preconditions;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class AutoProduceBytesSchema<T>
implements Schema<byte[]> {
    private boolean requireSchemaValidation = true;
    private Schema<T> schema;

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
        this.requireSchemaValidation = schema.getSchemaInfo() != null && SchemaType.BYTES != schema.getSchemaInfo().getType() && SchemaType.NONE != schema.getSchemaInfo().getType();
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState((null != this.schema ? 1 : 0) != 0, (Object)"Schema is not initialized before used");
    }

    @Override
    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    @Override
    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.validate(message);
        }
        return message;
    }

    @Override
    public byte[] decode(byte[] bytes) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.decode(bytes);
        }
        return bytes;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }
}

