/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSchema<T>
implements org.apache.pulsar.client.api.Schema<T> {
    private static final Logger log = LoggerFactory.getLogger(JSONSchema.class);
    private final Schema schema;
    private final SchemaInfo schemaInfo;
    private final Gson gson;
    private final Class<T> pojo;
    private Map<String, String> properties;

    private JSONSchema(final Class<T> pojo, Map<String, String> properties) {
        this.pojo = pojo;
        this.properties = properties;
        this.gson = new GsonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){
            Set<String> classes = new HashSet<String>();

            @Override
            public boolean shouldSkipField(FieldAttributes f) {
                boolean skip;
                boolean bl = skip = !f.getDeclaringClass().equals(pojo) && !this.classes.contains(f.getDeclaringClass().getName()) && !f.getDeclaringClass().isAssignableFrom(pojo);
                if (!skip) {
                    this.classes.add(f.getDeclaredClass().getName());
                }
                return skip;
            }

            @Override
            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }).create();
        this.schema = ReflectData.AllowNull.get().getSchema(pojo);
        this.schemaInfo = new SchemaInfo();
        this.schemaInfo.setName("");
        this.schemaInfo.setProperties(properties);
        this.schemaInfo.setType(SchemaType.JSON);
        this.schemaInfo.setSchema(this.schema.toString().getBytes());
    }

    @Override
    public byte[] encode(T message) throws SchemaSerializationException {
        try {
            return this.gson.toJson(message).getBytes();
        }
        catch (RuntimeException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            return this.gson.fromJson(new String(bytes), this.pojo);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(new SchemaSerializationException(e));
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public SchemaInfo getBackwardsCompatibleJsonSchemaInfo() {
        SchemaInfo backwardsCompatibleSchemaInfo;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(objectMapper);
            JsonSchema jsonBackwardsCompatibileSchema = schemaGen.generateSchema(this.pojo);
            backwardsCompatibleSchemaInfo = new SchemaInfo();
            backwardsCompatibleSchemaInfo.setName("");
            backwardsCompatibleSchemaInfo.setProperties(this.properties);
            backwardsCompatibleSchemaInfo.setType(SchemaType.JSON);
            backwardsCompatibleSchemaInfo.setSchema(objectMapper.writeValueAsBytes(jsonBackwardsCompatibileSchema));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return backwardsCompatibleSchemaInfo;
    }

    public static <T> JSONSchema<T> of(Class<T> pojo) {
        return new JSONSchema<T>(pojo, Collections.emptyMap());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return new JSONSchema<T>(pojo, properties);
    }
}

