/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.Schema;

public abstract class GenericSchema
implements org.apache.pulsar.client.api.Schema<GenericRecord> {
    protected final Schema schema;
    protected final List<Field> fields;
    protected final SchemaInfo schemaInfo;

    protected GenericSchema(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        this.schema = new Schema.Parser().parse(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8));
        this.fields = this.schema.getFields().stream().map(f -> new Field(f.name(), f.pos())).collect(Collectors.toList());
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public static GenericSchema of(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case AVRO: {
                return new GenericAvroSchema(schemaInfo);
            }
            case JSON: {
                return new GenericJsonSchema(schemaInfo);
            }
        }
        throw new UnsupportedOperationException("Generic schema is not supported on schema type '" + schemaInfo.getType() + "'");
    }
}

