/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.UnaryOperator;
import org.apache.pulsar.client.impl.PulsarClientImpl;

abstract class HandlerState {
    protected final PulsarClientImpl client;
    protected final String topic;
    private static final AtomicReferenceFieldUpdater<HandlerState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(HandlerState.class, State.class, "state");
    private volatile State state = null;

    public HandlerState(PulsarClientImpl client, String topic) {
        this.client = client;
        this.topic = topic;
        STATE_UPDATER.set(this, State.Uninitialized);
    }

    protected boolean changeToReadyState() {
        return STATE_UPDATER.compareAndSet(this, State.Uninitialized, State.Ready) || STATE_UPDATER.compareAndSet(this, State.Connecting, State.Ready);
    }

    protected State getState() {
        return STATE_UPDATER.get(this);
    }

    protected void setState(State s) {
        STATE_UPDATER.set(this, s);
    }

    abstract String getHandlerName();

    protected State getAndUpdateState(UnaryOperator<State> updater) {
        return STATE_UPDATER.getAndUpdate(this, updater);
    }

    static enum State {
        Uninitialized,
        Connecting,
        Ready,
        Closing,
        Closed,
        Terminated,
        Failed;

    }
}

