/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.impl;

import java.nio.ByteBuffer;
import org.apache.pulsar.shade.com.scurrilous.circe.StatefulHash;
import org.apache.pulsar.shade.com.scurrilous.circe.impl.DirectByteBufferAccessLoader;

public abstract class AbstractStatefulHash
implements StatefulHash {
    @Override
    public boolean supportsUnsafe() {
        return false;
    }

    @Override
    public void update(byte[] input) {
        this.updateUnchecked(input, 0, input.length);
    }

    @Override
    public void update(byte[] input, int index, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index + length > input.length) {
            throw new IndexOutOfBoundsException();
        }
        this.updateUnchecked(input, index, length);
    }

    @Override
    public void update(ByteBuffer input) {
        int index;
        byte[] array;
        int length = input.remaining();
        if (input.hasArray()) {
            array = input.array();
            index = input.arrayOffset() + input.position();
            input.position(input.limit());
        } else {
            long address;
            if (input.isDirect() && this.supportsUnsafe() && (address = DirectByteBufferAccessLoader.getAddress(input)) != 0L) {
                input.position(input.limit());
                this.update(address += (long)input.position(), length);
                return;
            }
            array = new byte[length];
            index = 0;
            input.get(array);
        }
        this.updateUnchecked(array, index, length);
    }

    @Override
    public void update(long address, long length) {
        throw new UnsupportedOperationException();
    }

    protected abstract void updateUnchecked(byte[] var1, int var2, int var3);

    @Override
    public byte[] getBytes() {
        byte[] array = new byte[this.length()];
        this.writeBytes(array, 0, array.length);
        return array;
    }

    @Override
    public int getBytes(byte[] output, int index, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index + maxLength > output.length) {
            throw new IndexOutOfBoundsException();
        }
        int length = Math.min(maxLength, this.length());
        this.writeBytes(output, index, length);
        return length;
    }

    protected void writeBytes(byte[] output, int index, int length) {
        long temp = this.getLong();
        for (int i = 0; i < length; ++i) {
            output[index + i] = (byte)temp;
            temp >>>= 8;
        }
    }

    @Override
    public byte getByte() {
        return (byte)this.getInt();
    }

    @Override
    public short getShort() {
        return (short)this.getInt();
    }
}

