/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.shade.org.apache.commons.collections.set.ListOrderedSet;
import org.apache.pulsar.shade.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.shade.org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.pulsar.shade.org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.pulsar.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.pulsar.shade.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.pulsar.shade.org.apache.commons.configuration.tree.ViewNode;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;

public class HierarchicalINIConfiguration
extends AbstractHierarchicalFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";
    private static final long serialVersionUID = 2548006161386850670L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LINE_CONT = "\\";

    public HierarchicalINIConfiguration() {
    }

    public HierarchicalINIConfiguration(String filename) throws ConfigurationException {
        super(filename);
    }

    public HierarchicalINIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public HierarchicalINIConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public void save(Writer writer) throws ConfigurationException {
        PrintWriter out = new PrintWriter(writer);
        Iterator it = this.getSections().iterator();
        while (it.hasNext()) {
            String section = (String)it.next();
            if (section != null) {
                out.print("[");
                out.print(section);
                out.print("]");
                out.println();
            }
            SubnodeConfiguration subset = this.getSection(section);
            Iterator keys = subset.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = subset.getProperty(key);
                if (value instanceof Collection) {
                    Iterator values = ((Collection)value).iterator();
                    while (values.hasNext()) {
                        value = values.next();
                        out.print(key);
                        out.print(" = ");
                        out.print(this.formatValue(value.toString()));
                        out.println();
                    }
                    continue;
                }
                out.print(key);
                out.print(" = ");
                out.print(this.formatValue(value.toString()));
                out.println();
            }
            out.println();
        }
        out.flush();
    }

    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            ConfigurationNode sectionNode = this.getRootNode();
            String line = bufferedReader.readLine();
            while (line != null) {
                if (!this.isCommentLine(line = line.trim())) {
                    if (this.isSectionLine(line)) {
                        String section = line.substring(1, line.length() - 1);
                        sectionNode = this.getSectionNode(section);
                    } else {
                        String key = "";
                        String value = "";
                        int index = line.indexOf("=");
                        if (index >= 0) {
                            key = line.substring(0, index);
                            value = HierarchicalINIConfiguration.parseValue(line.substring(index + 1), bufferedReader);
                        } else {
                            index = line.indexOf(":");
                            if (index >= 0) {
                                key = line.substring(0, index);
                                value = HierarchicalINIConfiguration.parseValue(line.substring(index + 1), bufferedReader);
                            } else {
                                key = line;
                            }
                        }
                        key = key.trim();
                        if (key.length() < 1) {
                            key = " ";
                        }
                        HierarchicalConfiguration.Node node = this.createNode(key);
                        node.setValue(value);
                        sectionNode.addChild(node);
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    private static String parseValue(String val, BufferedReader reader) throws IOException {
        boolean lineContinues;
        StringBuffer propertyValue = new StringBuffer();
        String value = val.trim();
        do {
            int i;
            boolean quoted = value.startsWith("\"") || value.startsWith("'");
            boolean stop = false;
            boolean escape = false;
            char quote = quoted ? value.charAt(0) : (char)'\u0000';
            StringBuffer result = new StringBuffer();
            for (i = quoted ? 1 : 0; i < value.length() && !stop; ++i) {
                char c = value.charAt(i);
                if (quoted) {
                    if ('\\' == c && !escape) {
                        escape = true;
                        continue;
                    }
                    if (!escape && quote == c) {
                        stop = true;
                        continue;
                    }
                    if (escape && quote == c) {
                        escape = false;
                        result.append(c);
                        continue;
                    }
                    if (escape) {
                        escape = false;
                        result.append('\\');
                    }
                    result.append(c);
                    continue;
                }
                if (!HierarchicalINIConfiguration.isCommentChar(c)) {
                    result.append(c);
                    continue;
                }
                stop = true;
            }
            String v = result.toString();
            if (!quoted) {
                lineContinues = HierarchicalINIConfiguration.lineContinues(v = v.trim());
                if (lineContinues) {
                    v = v.substring(0, v.length() - 1).trim();
                }
            } else {
                lineContinues = HierarchicalINIConfiguration.lineContinues(value, i);
            }
            propertyValue.append(v);
            if (!lineContinues) continue;
            propertyValue.append(LINE_SEPARATOR);
            value = reader.readLine();
        } while (lineContinues && value != null);
        return propertyValue.toString();
    }

    private static boolean lineContinues(String line) {
        String s = line.trim();
        return s.equals(LINE_CONT) || s.length() > 2 && s.endsWith(LINE_CONT) && Character.isWhitespace(s.charAt(s.length() - 2));
    }

    private static boolean lineContinues(String line, int pos) {
        String s;
        if (pos >= line.length()) {
            s = line;
        } else {
            int end;
            for (end = pos; end < line.length() && !HierarchicalINIConfiguration.isCommentChar(line.charAt(end)); ++end) {
            }
            s = line.substring(pos, end);
        }
        return HierarchicalINIConfiguration.lineContinues(s);
    }

    private static boolean isCommentChar(char c) {
        return COMMENT_CHARS.indexOf(c) >= 0;
    }

    private String formatValue(String value) {
        boolean quoted = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !quoted; ++i) {
            char c = COMMENT_CHARS.charAt(i);
            if (value.indexOf(c) == -1) continue;
            quoted = true;
        }
        if (quoted) {
            return '\"' + StringUtils.replace(value, "\"", "\\\"") + '\"';
        }
        return value;
    }

    protected boolean isCommentLine(String line) {
        if (line == null) {
            return false;
        }
        return line.length() < 1 || COMMENT_CHARS.indexOf(line.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith("[") && line.endsWith("]");
    }

    public Set getSections() {
        ListOrderedSet sections = new ListOrderedSet();
        boolean globalSection = false;
        Iterator it = this.getRootNode().getChildren().iterator();
        while (it.hasNext()) {
            ConfigurationNode node = (ConfigurationNode)it.next();
            if (HierarchicalINIConfiguration.isSectionNode(node)) {
                if (globalSection) {
                    sections.add(null);
                    globalSection = false;
                }
                sections.add(node.getName());
                continue;
            }
            globalSection = true;
        }
        return sections;
    }

    public SubnodeConfiguration getSection(String name) {
        if (name == null) {
            return this.getGlobalSection();
        }
        try {
            return this.configurationAt(name);
        }
        catch (IllegalArgumentException iex) {
            return new SubnodeConfiguration(this, new DefaultConfigurationNode());
        }
    }

    private ConfigurationNode getSectionNode(String sectionName) {
        List nodes = this.getRootNode().getChildren(sectionName);
        if (!nodes.isEmpty()) {
            return (ConfigurationNode)nodes.get(0);
        }
        HierarchicalConfiguration.Node node = this.createNode(sectionName);
        HierarchicalINIConfiguration.markSectionNode(node);
        this.getRootNode().addChild(node);
        return node;
    }

    private SubnodeConfiguration getGlobalSection() {
        ViewNode parent = new ViewNode();
        Iterator it = this.getRootNode().getChildren().iterator();
        while (it.hasNext()) {
            ConfigurationNode node = (ConfigurationNode)it.next();
            if (HierarchicalINIConfiguration.isSectionNode(node)) continue;
            parent.addChild(node);
        }
        return this.createSubnodeConfiguration(parent);
    }

    private static void markSectionNode(ConfigurationNode node) {
        node.setReference(Boolean.TRUE);
    }

    private static boolean isSectionNode(ConfigurationNode node) {
        return node.getReference() != null || node.getChildrenCount() > 0;
    }
}

