/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerBase;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class TypedMessageBuilderImpl<T>
implements TypedMessageBuilder<T> {
    private static final ByteBuffer EMPTY_CONTENT = ByteBuffer.allocate(0);
    private final ProducerBase<T> producer;
    private final PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
    private final Schema<T> schema;
    private ByteBuffer content;

    public TypedMessageBuilderImpl(ProducerBase<T> producer, Schema<T> schema) {
        this.producer = producer;
        this.schema = schema;
        this.content = EMPTY_CONTENT;
    }

    @Override
    public MessageId send() throws PulsarClientException {
        return this.producer.send(MessageImpl.create(this.msgMetadataBuilder, this.content, this.schema));
    }

    @Override
    public CompletableFuture<MessageId> sendAsync() {
        return this.producer.internalSendAsync(MessageImpl.create(this.msgMetadataBuilder, this.content, this.schema));
    }

    @Override
    public TypedMessageBuilder<T> key(String key) {
        this.msgMetadataBuilder.setPartitionKey(key);
        this.msgMetadataBuilder.setPartitionKeyB64Encoded(false);
        return this;
    }

    @Override
    public TypedMessageBuilder<T> keyBytes(byte[] key) {
        this.msgMetadataBuilder.setPartitionKey(Base64.getEncoder().encodeToString(key));
        this.msgMetadataBuilder.setPartitionKeyB64Encoded(true);
        return this;
    }

    @Override
    public TypedMessageBuilder<T> value(T value) {
        Preconditions.checkArgument(value != null, "Need Non-Null content value");
        this.content = ByteBuffer.wrap(this.schema.encode(value));
        return this;
    }

    @Override
    public TypedMessageBuilder<T> property(String name, String value) {
        Preconditions.checkArgument(name != null, "Need Non-Null name");
        Preconditions.checkArgument(value != null, "Need Non-Null value for name: " + name);
        this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(name).setValue(value).build());
        return this;
    }

    @Override
    public TypedMessageBuilder<T> properties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument(entry.getKey() != null, "Need Non-Null key");
            Preconditions.checkArgument(entry.getValue() != null, "Need Non-Null value for key: " + entry.getKey());
            this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return this;
    }

    @Override
    public TypedMessageBuilder<T> eventTime(long timestamp) {
        Preconditions.checkArgument(timestamp > 0L, "Invalid timestamp : '%s'", timestamp);
        this.msgMetadataBuilder.setEventTime(timestamp);
        return this;
    }

    @Override
    public TypedMessageBuilder<T> sequenceId(long sequenceId) {
        Preconditions.checkArgument(sequenceId >= 0L);
        this.msgMetadataBuilder.setSequenceId(sequenceId);
        return this;
    }

    @Override
    public TypedMessageBuilder<T> replicationClusters(List<String> clusters) {
        Preconditions.checkNotNull(clusters);
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addAllReplicateTo(clusters);
        return this;
    }

    @Override
    public TypedMessageBuilder<T> disableReplication() {
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addReplicateTo("__local__");
        return this;
    }

    public long getPublishTime() {
        return this.msgMetadataBuilder.getPublishTime();
    }

    public boolean hasKey() {
        return this.msgMetadataBuilder.hasPartitionKey();
    }

    public String getKey() {
        return this.msgMetadataBuilder.getPartitionKey();
    }

    public ByteBuffer getContent() {
        return this.content;
    }
}

