/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class ConsumerConfigurationData<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Set<String> topicNames = Sets.newTreeSet();
    private Pattern topicsPattern;
    private String subscriptionName;
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    @JsonIgnore
    private MessageListener<T> messageListener;
    @JsonIgnore
    private ConsumerEventListener consumerEventListener;
    private int receiverQueueSize = 1000;
    private long acknowledgementsGroupTimeMicros = TimeUnit.MILLISECONDS.toMicros(100L);
    private int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    private String consumerName = null;
    private long ackTimeoutMillis = 0L;
    private int priorityLevel = 0;
    @JsonIgnore
    private CryptoKeyReader cryptoKeyReader = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private SortedMap<String, String> properties = new TreeMap<String, String>();
    private boolean readCompacted = false;
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
    private int patternAutoDiscoveryPeriod = 1;
    private PulsarApi.CommandGetTopicsOfNamespace.Mode subscriptionTopicsMode = PulsarApi.CommandGetTopicsOfNamespace.Mode.PERSISTENT;
    private DeadLetterPolicy deadLetterPolicy;

    @JsonIgnore
    public String getSingleTopic() {
        Preconditions.checkArgument(this.topicNames.size() == 1);
        return this.topicNames.iterator().next();
    }

    public ConsumerConfigurationData<T> clone() {
        try {
            ConsumerConfigurationData c = (ConsumerConfigurationData)super.clone();
            c.topicNames = Sets.newTreeSet(this.topicNames);
            c.properties = Maps.newTreeMap(this.properties);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ConsumerConfigurationData");
        }
    }

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public Pattern getTopicsPattern() {
        return this.topicsPattern;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public MessageListener<T> getMessageListener() {
        return this.messageListener;
    }

    public ConsumerEventListener getConsumerEventListener() {
        return this.consumerEventListener;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public long getAcknowledgementsGroupTimeMicros() {
        return this.acknowledgementsGroupTimeMicros;
    }

    public int getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    public int getPatternAutoDiscoveryPeriod() {
        return this.patternAutoDiscoveryPeriod;
    }

    public PulsarApi.CommandGetTopicsOfNamespace.Mode getSubscriptionTopicsMode() {
        return this.subscriptionTopicsMode;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public void setTopicNames(Set<String> topicNames) {
        this.topicNames = topicNames;
    }

    public void setTopicsPattern(Pattern topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public void setMessageListener(MessageListener<T> messageListener) {
        this.messageListener = messageListener;
    }

    public void setConsumerEventListener(ConsumerEventListener consumerEventListener) {
        this.consumerEventListener = consumerEventListener;
    }

    public void setReceiverQueueSize(int receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public void setAcknowledgementsGroupTimeMicros(long acknowledgementsGroupTimeMicros) {
        this.acknowledgementsGroupTimeMicros = acknowledgementsGroupTimeMicros;
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setAckTimeoutMillis(long ackTimeoutMillis) {
        this.ackTimeoutMillis = ackTimeoutMillis;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public void setPatternAutoDiscoveryPeriod(int patternAutoDiscoveryPeriod) {
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
    }

    public void setSubscriptionTopicsMode(PulsarApi.CommandGetTopicsOfNamespace.Mode subscriptionTopicsMode) {
        this.subscriptionTopicsMode = subscriptionTopicsMode;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfigurationData)) {
            return false;
        }
        ConsumerConfigurationData other = (ConsumerConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$topicNames = this.getTopicNames();
        Set<String> other$topicNames = other.getTopicNames();
        if (this$topicNames == null ? other$topicNames != null : !((Object)this$topicNames).equals(other$topicNames)) {
            return false;
        }
        Pattern this$topicsPattern = this.getTopicsPattern();
        Pattern other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        SubscriptionType this$subscriptionType = this.getSubscriptionType();
        SubscriptionType other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !((Object)((Object)this$subscriptionType)).equals((Object)other$subscriptionType)) {
            return false;
        }
        MessageListener<T> this$messageListener = this.getMessageListener();
        MessageListener<T> other$messageListener = other.getMessageListener();
        if (this$messageListener == null ? other$messageListener != null : !this$messageListener.equals(other$messageListener)) {
            return false;
        }
        ConsumerEventListener this$consumerEventListener = this.getConsumerEventListener();
        ConsumerEventListener other$consumerEventListener = other.getConsumerEventListener();
        if (this$consumerEventListener == null ? other$consumerEventListener != null : !this$consumerEventListener.equals(other$consumerEventListener)) {
            return false;
        }
        if (this.getReceiverQueueSize() != other.getReceiverQueueSize()) {
            return false;
        }
        if (this.getAcknowledgementsGroupTimeMicros() != other.getAcknowledgementsGroupTimeMicros()) {
            return false;
        }
        if (this.getMaxTotalReceiverQueueSizeAcrossPartitions() != other.getMaxTotalReceiverQueueSizeAcrossPartitions()) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        if (this.getAckTimeoutMillis() != other.getAckTimeoutMillis()) {
            return false;
        }
        if (this.getPriorityLevel() != other.getPriorityLevel()) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        ConsumerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ConsumerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !((Object)((Object)this$cryptoFailureAction)).equals((Object)other$cryptoFailureAction)) {
            return false;
        }
        SortedMap<String, String> this$properties = this.getProperties();
        SortedMap<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        if (this.isReadCompacted() != other.isReadCompacted()) {
            return false;
        }
        SubscriptionInitialPosition this$subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        SubscriptionInitialPosition other$subscriptionInitialPosition = other.getSubscriptionInitialPosition();
        if (this$subscriptionInitialPosition == null ? other$subscriptionInitialPosition != null : !((Object)((Object)this$subscriptionInitialPosition)).equals((Object)other$subscriptionInitialPosition)) {
            return false;
        }
        if (this.getPatternAutoDiscoveryPeriod() != other.getPatternAutoDiscoveryPeriod()) {
            return false;
        }
        PulsarApi.CommandGetTopicsOfNamespace.Mode this$subscriptionTopicsMode = this.getSubscriptionTopicsMode();
        PulsarApi.CommandGetTopicsOfNamespace.Mode other$subscriptionTopicsMode = other.getSubscriptionTopicsMode();
        if (this$subscriptionTopicsMode == null ? other$subscriptionTopicsMode != null : !((Object)((Object)this$subscriptionTopicsMode)).equals((Object)other$subscriptionTopicsMode)) {
            return false;
        }
        DeadLetterPolicy this$deadLetterPolicy = this.getDeadLetterPolicy();
        DeadLetterPolicy other$deadLetterPolicy = other.getDeadLetterPolicy();
        return !(this$deadLetterPolicy == null ? other$deadLetterPolicy != null : !((Object)this$deadLetterPolicy).equals(other$deadLetterPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumerConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $topicNames = this.getTopicNames();
        result = result * 59 + ($topicNames == null ? 43 : ((Object)$topicNames).hashCode());
        Pattern $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        SubscriptionType $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : ((Object)((Object)$subscriptionType)).hashCode());
        MessageListener<T> $messageListener = this.getMessageListener();
        result = result * 59 + ($messageListener == null ? 43 : $messageListener.hashCode());
        ConsumerEventListener $consumerEventListener = this.getConsumerEventListener();
        result = result * 59 + ($consumerEventListener == null ? 43 : $consumerEventListener.hashCode());
        result = result * 59 + this.getReceiverQueueSize();
        long $acknowledgementsGroupTimeMicros = this.getAcknowledgementsGroupTimeMicros();
        result = result * 59 + (int)($acknowledgementsGroupTimeMicros >>> 32 ^ $acknowledgementsGroupTimeMicros);
        result = result * 59 + this.getMaxTotalReceiverQueueSizeAcrossPartitions();
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        long $ackTimeoutMillis = this.getAckTimeoutMillis();
        result = result * 59 + (int)($ackTimeoutMillis >>> 32 ^ $ackTimeoutMillis);
        result = result * 59 + this.getPriorityLevel();
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        ConsumerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : ((Object)((Object)$cryptoFailureAction)).hashCode());
        SortedMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        result = result * 59 + (this.isReadCompacted() ? 79 : 97);
        SubscriptionInitialPosition $subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        result = result * 59 + ($subscriptionInitialPosition == null ? 43 : ((Object)((Object)$subscriptionInitialPosition)).hashCode());
        result = result * 59 + this.getPatternAutoDiscoveryPeriod();
        PulsarApi.CommandGetTopicsOfNamespace.Mode $subscriptionTopicsMode = this.getSubscriptionTopicsMode();
        result = result * 59 + ($subscriptionTopicsMode == null ? 43 : ((Object)((Object)$subscriptionTopicsMode)).hashCode());
        DeadLetterPolicy $deadLetterPolicy = this.getDeadLetterPolicy();
        result = result * 59 + ($deadLetterPolicy == null ? 43 : ((Object)$deadLetterPolicy).hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerConfigurationData(topicNames=" + this.getTopicNames() + ", topicsPattern=" + this.getTopicsPattern() + ", subscriptionName=" + this.getSubscriptionName() + ", subscriptionType=" + (Object)((Object)this.getSubscriptionType()) + ", messageListener=" + this.getMessageListener() + ", consumerEventListener=" + this.getConsumerEventListener() + ", receiverQueueSize=" + this.getReceiverQueueSize() + ", acknowledgementsGroupTimeMicros=" + this.getAcknowledgementsGroupTimeMicros() + ", maxTotalReceiverQueueSizeAcrossPartitions=" + this.getMaxTotalReceiverQueueSizeAcrossPartitions() + ", consumerName=" + this.getConsumerName() + ", ackTimeoutMillis=" + this.getAckTimeoutMillis() + ", priorityLevel=" + this.getPriorityLevel() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", cryptoFailureAction=" + (Object)((Object)this.getCryptoFailureAction()) + ", properties=" + this.getProperties() + ", readCompacted=" + this.isReadCompacted() + ", subscriptionInitialPosition=" + (Object)((Object)this.getSubscriptionInitialPosition()) + ", patternAutoDiscoveryPeriod=" + this.getPatternAutoDiscoveryPeriod() + ", subscriptionTopicsMode=" + (Object)((Object)this.getSubscriptionTopicsMode()) + ", deadLetterPolicy=" + this.getDeadLetterPolicy() + ")";
    }
}

