/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.handler;

import java.io.IOException;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpContent;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpObject;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.shade.io.netty.util.concurrent.EventExecutorGroup;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseBodyPart;
import org.apache.pulsar.shade.org.asynchttpclient.handler.StreamedAsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseStatus;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.Channels;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;

@ChannelHandler.Sharable
public final class HttpHandler
extends AsyncHttpClientHandler {
    public HttpHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    private boolean abortAfterHandlingStatus(AsyncHandler<?> handler, NettyResponseStatus status) throws Exception {
        return handler.onStatusReceived(status) == AsyncHandler.State.ABORT;
    }

    private boolean abortAfterHandlingHeaders(AsyncHandler<?> handler, HttpHeaders responseHeaders) throws Exception {
        return !responseHeaders.isEmpty() && handler.onHeadersReceived(responseHeaders) == AsyncHandler.State.ABORT;
    }

    private boolean abortAfterHandlingReactiveStreams(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException {
        if (handler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedAsyncHandler = (StreamedAsyncHandler)handler;
            StreamedResponsePublisher publisher = new StreamedResponsePublisher(channel.eventLoop(), this.channelManager, future, channel);
            channel.pipeline().addLast((EventExecutorGroup)channel.eventLoop(), "streamedAsyncHandler", (ChannelHandler)publisher);
            Channels.setAttribute(channel, publisher);
            return streamedAsyncHandler.onStream(publisher) == AsyncHandler.State.ABORT;
        }
        return false;
    }

    private void handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setKeepAlive(this.config.getKeepAliveStrategy().keepAlive(future.getTargetRequest(), httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), response, channel);
        HttpHeaders responseHeaders = response.headers();
        if (!this.interceptors.exitAfterIntercept(channel, future, handler, response, status, responseHeaders)) {
            boolean abort;
            boolean bl = abort = this.abortAfterHandlingStatus(handler, status) || this.abortAfterHandlingHeaders(handler, responseHeaders) || this.abortAfterHandlingReactiveStreams(channel, future, handler);
            if (abort) {
                this.finishUpdate(future, channel, true);
            }
        }
    }

    private void handleChunk(HttpContent chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException, Exception {
        LastHttpContent lastChunk;
        HttpHeaders trailingHeaders;
        boolean abort = false;
        boolean last = chunk instanceof LastHttpContent;
        if (last && !(trailingHeaders = (lastChunk = (LastHttpContent)chunk).trailingHeaders()).isEmpty()) {
            abort = handler.onTrailingHeadersReceived(trailingHeaders) == AsyncHandler.State.ABORT;
        }
        ByteBuf buf = chunk.content();
        if (!abort && !(handler instanceof StreamedAsyncHandler) && (buf.isReadable() || last)) {
            HttpResponseBodyPart bodyPart = this.config.getResponseBodyPartFactory().newResponseBodyPart(buf, last);
            boolean bl = abort = handler.onBodyPartReceived(bodyPart) == AsyncHandler.State.ABORT;
        }
        if (abort || last) {
            boolean close = abort || !future.isKeepAlive();
            this.finishUpdate(future, channel, close);
        }
    }

    @Override
    public void handleRead(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            HttpObject object;
            Throwable t;
            if (e instanceof HttpObject && (t = (object = (HttpObject)e).decoderResult().cause()) != null) {
                this.readFailed(channel, future, t);
                return;
            }
            if (e instanceof HttpResponse) {
                this.handleHttpResponse((HttpResponse)e, channel, future, handler);
            } else if (e instanceof HttpContent) {
                this.handleChunk((HttpContent)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            this.readFailed(channel, future, t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFailed(Channel channel, NettyResponseFuture<?> future, Throwable t) throws Exception {
        try {
            this.requestSender.abort(channel, future, t);
        }
        catch (Exception abortException) {
            this.logger.debug("Abort failed", (Throwable)abortException);
        }
        finally {
            this.finishUpdate(future, channel, true);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future, Throwable error) {
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future) {
    }
}

