/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ObjectCache;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelInitializer;
import org.apache.pulsar.shade.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.shade.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final boolean tlsEnabled;
    private final Supplier<SslContext> sslContextSupplier;
    private static final long TLS_CERTIFICATE_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier) throws Exception {
        this.clientCnxSupplier = clientCnxSupplier;
        this.tlsEnabled = conf.isUseTls();
        this.sslContextSupplier = conf.isUseTls() ? new ObjectCache<SslContext>(() -> {
            try {
                AuthenticationDataProvider authData = conf.getAuthentication().getAuthData();
                if (authData.hasDataForTls()) {
                    return SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), (X509Certificate[])authData.getTlsCertificates(), authData.getTlsPrivateKey());
                }
                return SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create TLS context", e);
            }
        }, TLS_CERTIFICATE_CACHE_MILLIS, TimeUnit.MILLISECONDS) : null;
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        if (this.tlsEnabled) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)this.sslContextSupplier.get().newHandler(ch.alloc()));
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.COPYING_ENCODER);
        } else {
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)this.clientCnxSupplier.get());
    }
}

