/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.sql.Timestamp;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class TimestampSchema
implements Schema<Timestamp> {
    private static final TimestampSchema INSTANCE = new TimestampSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("Timestamp").setType(SchemaType.TIMESTAMP).setSchema(new byte[0]);

    public static TimestampSchema of() {
        return INSTANCE;
    }

    public byte[] encode(Timestamp message) {
        if (null == message) {
            return null;
        }
        Long timestamp = message.getTime();
        return LongSchema.of().encode(timestamp);
    }

    public Timestamp decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return new Timestamp(decode);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

