/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericRecordBuilder;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.impl.schema.generic.AvroRecordBuilderImpl;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroReader;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroWriter;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAvroSchema
extends GenericSchemaImpl {
    private static final Logger log = LoggerFactory.getLogger(GenericAvroSchema.class);

    public GenericAvroSchema(SchemaInfo schemaInfo) {
        this(schemaInfo, true);
    }

    GenericAvroSchema(SchemaInfo schemaInfo, boolean useProvidedSchemaAsReaderSchema) {
        super(schemaInfo, useProvidedSchemaAsReaderSchema);
        this.setReader(new GenericAvroReader(this.schema));
        this.setWriter(new GenericAvroWriter(this.schema));
    }

    public GenericRecordBuilder newRecordBuilder() {
        return new AvroRecordBuilderImpl(this);
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    @Override
    protected SchemaReader<GenericRecord> loadReader(byte[] schemaVersion) {
        SchemaInfo schemaInfo = this.schemaInfoProvider.getSchemaByVersion(schemaVersion);
        if (schemaInfo != null) {
            log.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion), (Object)schemaInfo.getSchemaDefinition());
            Schema writerSchema = GenericAvroSchema.parseAvroSchema(schemaInfo.getSchemaDefinition());
            Schema readerSchema = this.useProvidedSchemaAsReaderSchema ? this.schema : writerSchema;
            return new GenericAvroReader(writerSchema, readerSchema, schemaVersion);
        }
        log.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion), (Object)this.schemaInfo.getSchemaDefinition());
        return this.reader;
    }
}

