/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;

public class DefaultSslContextBuilder
extends SslContextAutoRefreshBuilder<SSLContext> {
    private volatile SSLContext sslContext;

    public DefaultSslContextBuilder(boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, boolean requireTrustedClientCertOnConnect, long certRefreshInSec) throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        super(allowInsecure, trustCertsFilePath, certificateFilePath, keyFilePath, null, null, requireTrustedClientCertOnConnect, certRefreshInSec);
    }

    @Override
    public synchronized SSLContext update() throws GeneralSecurityException {
        this.sslContext = SecurityUtility.createSslContext(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName());
        return this.sslContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }
}

