/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.Map;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.impl.AutoFailoverPolicyFactory;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;

@ApiModel(value="AutoFailoverPolicyData", description="The auto failover policy configuration data")
public class AutoFailoverPolicyData {
    @ApiModelProperty(name="policy_type", value="The auto failover policy type", allowableValues="min_available")
    public AutoFailoverPolicyType policy_type;
    @ApiModelProperty(name="parameters", value="The parameters applied to the auto failover policy specified by `policy_type`.\nThe parameters for 'min_available' are :\n  - 'min_limit': the limit of minimal number of available brokers in primary group before auto failover\n  - 'usage_threshold': the resource usage threshold. If the usage of a broker is beyond this value, it would be marked as unavailable\n", example="{\n  \"min_limit\": 3,\n  \"usage_threshold\": 80\n}\n")
    public Map<String, String> parameters;

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.policy_type, this.parameters});
    }

    public boolean equals(Object obj) {
        if (obj instanceof AutoFailoverPolicyData) {
            AutoFailoverPolicyData other = (AutoFailoverPolicyData)obj;
            return Objects.equal((Object)this.policy_type, (Object)other.policy_type) && Objects.equal(this.parameters, other.parameters);
        }
        return false;
    }

    public void validate() {
        Preconditions.checkArgument(this.policy_type != null && this.parameters != null);
        AutoFailoverPolicyFactory.create(this);
    }

    public String toString() {
        return String.format("policy_type=%s parameters=%s", new Object[]{this.policy_type, this.parameters});
    }
}

