/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.policies.data.stats.TopicMetricBean;

public class SubscriptionStatsImpl
implements SubscriptionStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double msgRateRedeliver;
    public double messageAckRate;
    public int chunkedMessageRate;
    public long msgBacklog;
    public long backlogSize;
    public long earliestMsgPublishTimeInBacklog;
    public long msgBacklogNoDelayed;
    public boolean blockedSubscriptionOnUnackedMsgs;
    public long msgDelayed;
    public long unackedMessages;
    public String type;
    public String activeConsumerName;
    public double msgRateExpired;
    public long totalMsgExpired;
    public long lastExpireTimestamp;
    public long lastConsumedFlowTimestamp;
    public long lastConsumedTimestamp;
    public long lastAckedTimestamp;
    public long lastMarkDeleteAdvancedTimestamp;
    public List<ConsumerStatsImpl> consumers = new ArrayList<ConsumerStatsImpl>();
    public boolean isDurable;
    public boolean isReplicated;
    public boolean allowOutOfOrderDelivery;
    public String keySharedMode;
    public Map<String, String> consumersAfterMarkDeletePosition = new LinkedHashMap<String, String>();
    public int nonContiguousDeletedMessagesRanges;
    public int nonContiguousDeletedMessagesRangesSerializedSize;
    public long delayedMessageIndexSizeInBytes;
    @JsonIgnore
    public Map<String, TopicMetricBean> bucketDelayedIndexStats;
    public Map<String, String> subscriptionProperties = new HashMap<String, String>();
    public long filterProcessedMsgCount;
    public long filterAcceptedMsgCount;
    public long filterRejectedMsgCount;
    public long filterRescheduledMsgCount;

    public SubscriptionStatsImpl() {
        this.bucketDelayedIndexStats = new HashMap<String, TopicMetricBean>();
    }

    public void reset() {
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.bytesOutCounter = 0L;
        this.msgOutCounter = 0L;
        this.msgRateRedeliver = 0.0;
        this.messageAckRate = 0.0;
        this.chunkedMessageRate = 0;
        this.msgBacklog = 0L;
        this.backlogSize = 0L;
        this.msgBacklogNoDelayed = 0L;
        this.unackedMessages = 0L;
        this.type = null;
        this.msgRateExpired = 0.0;
        this.totalMsgExpired = 0L;
        this.lastExpireTimestamp = 0L;
        this.lastMarkDeleteAdvancedTimestamp = 0L;
        this.consumers.clear();
        this.consumersAfterMarkDeletePosition.clear();
        this.nonContiguousDeletedMessagesRanges = 0;
        this.nonContiguousDeletedMessagesRangesSerializedSize = 0;
        this.earliestMsgPublishTimeInBacklog = 0L;
        this.delayedMessageIndexSizeInBytes = 0L;
        this.subscriptionProperties.clear();
        this.filterProcessedMsgCount = 0L;
        this.filterAcceptedMsgCount = 0L;
        this.filterRejectedMsgCount = 0L;
        this.filterRescheduledMsgCount = 0L;
        this.bucketDelayedIndexStats.clear();
    }

    public SubscriptionStatsImpl add(SubscriptionStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.messageAckRate += stats.messageAckRate;
        this.chunkedMessageRate += stats.chunkedMessageRate;
        this.msgBacklog += stats.msgBacklog;
        this.backlogSize += stats.backlogSize;
        this.msgBacklogNoDelayed += stats.msgBacklogNoDelayed;
        this.msgDelayed += stats.msgDelayed;
        this.unackedMessages += stats.unackedMessages;
        this.type = stats.type;
        this.msgRateExpired += stats.msgRateExpired;
        this.totalMsgExpired += stats.totalMsgExpired;
        this.isReplicated |= stats.isReplicated;
        this.isDurable |= stats.isDurable;
        if (this.consumers.size() != stats.consumers.size()) {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                ConsumerStatsImpl consumerStats = new ConsumerStatsImpl();
                this.consumers.add(consumerStats.add(stats.consumers.get(i)));
            }
        } else {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                this.consumers.get(i).add(stats.consumers.get(i));
            }
        }
        this.allowOutOfOrderDelivery |= stats.allowOutOfOrderDelivery;
        this.consumersAfterMarkDeletePosition.putAll(stats.consumersAfterMarkDeletePosition);
        this.nonContiguousDeletedMessagesRanges += stats.nonContiguousDeletedMessagesRanges;
        this.nonContiguousDeletedMessagesRangesSerializedSize += stats.nonContiguousDeletedMessagesRangesSerializedSize;
        this.earliestMsgPublishTimeInBacklog = this.earliestMsgPublishTimeInBacklog != 0L && stats.earliestMsgPublishTimeInBacklog != 0L ? Math.min(this.earliestMsgPublishTimeInBacklog, stats.earliestMsgPublishTimeInBacklog) : Math.max(this.earliestMsgPublishTimeInBacklog, stats.earliestMsgPublishTimeInBacklog);
        this.delayedMessageIndexSizeInBytes += stats.delayedMessageIndexSizeInBytes;
        this.subscriptionProperties.putAll(stats.subscriptionProperties);
        this.filterProcessedMsgCount += stats.filterProcessedMsgCount;
        this.filterAcceptedMsgCount += stats.filterAcceptedMsgCount;
        this.filterRejectedMsgCount += stats.filterRejectedMsgCount;
        this.filterRescheduledMsgCount += stats.filterRescheduledMsgCount;
        stats.bucketDelayedIndexStats.forEach((k, v) -> {
            TopicMetricBean topicMetricBean = this.bucketDelayedIndexStats.computeIfAbsent((String)k, __ -> new TopicMetricBean());
            topicMetricBean.name = v.name;
            topicMetricBean.labelsAndValues = v.labelsAndValues;
            topicMetricBean.value += v.value;
        });
        return this;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public long getBytesOutCounter() {
        return this.bytesOutCounter;
    }

    public long getMsgOutCounter() {
        return this.msgOutCounter;
    }

    public double getMsgRateRedeliver() {
        return this.msgRateRedeliver;
    }

    public double getMessageAckRate() {
        return this.messageAckRate;
    }

    public int getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    public long getMsgBacklog() {
        return this.msgBacklog;
    }

    public long getBacklogSize() {
        return this.backlogSize;
    }

    public long getEarliestMsgPublishTimeInBacklog() {
        return this.earliestMsgPublishTimeInBacklog;
    }

    public long getMsgBacklogNoDelayed() {
        return this.msgBacklogNoDelayed;
    }

    public boolean isBlockedSubscriptionOnUnackedMsgs() {
        return this.blockedSubscriptionOnUnackedMsgs;
    }

    public long getMsgDelayed() {
        return this.msgDelayed;
    }

    public long getUnackedMessages() {
        return this.unackedMessages;
    }

    public String getType() {
        return this.type;
    }

    public String getActiveConsumerName() {
        return this.activeConsumerName;
    }

    public double getMsgRateExpired() {
        return this.msgRateExpired;
    }

    public long getTotalMsgExpired() {
        return this.totalMsgExpired;
    }

    public long getLastExpireTimestamp() {
        return this.lastExpireTimestamp;
    }

    public long getLastConsumedFlowTimestamp() {
        return this.lastConsumedFlowTimestamp;
    }

    public long getLastConsumedTimestamp() {
        return this.lastConsumedTimestamp;
    }

    public long getLastAckedTimestamp() {
        return this.lastAckedTimestamp;
    }

    public long getLastMarkDeleteAdvancedTimestamp() {
        return this.lastMarkDeleteAdvancedTimestamp;
    }

    public List<ConsumerStatsImpl> getConsumers() {
        return this.consumers;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public boolean isReplicated() {
        return this.isReplicated;
    }

    public boolean isAllowOutOfOrderDelivery() {
        return this.allowOutOfOrderDelivery;
    }

    public String getKeySharedMode() {
        return this.keySharedMode;
    }

    public Map<String, String> getConsumersAfterMarkDeletePosition() {
        return this.consumersAfterMarkDeletePosition;
    }

    public int getNonContiguousDeletedMessagesRanges() {
        return this.nonContiguousDeletedMessagesRanges;
    }

    public int getNonContiguousDeletedMessagesRangesSerializedSize() {
        return this.nonContiguousDeletedMessagesRangesSerializedSize;
    }

    public long getDelayedMessageIndexSizeInBytes() {
        return this.delayedMessageIndexSizeInBytes;
    }

    public Map<String, TopicMetricBean> getBucketDelayedIndexStats() {
        return this.bucketDelayedIndexStats;
    }

    public Map<String, String> getSubscriptionProperties() {
        return this.subscriptionProperties;
    }

    public long getFilterProcessedMsgCount() {
        return this.filterProcessedMsgCount;
    }

    public long getFilterAcceptedMsgCount() {
        return this.filterAcceptedMsgCount;
    }

    public long getFilterRejectedMsgCount() {
        return this.filterRejectedMsgCount;
    }

    public long getFilterRescheduledMsgCount() {
        return this.filterRescheduledMsgCount;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public void setBytesOutCounter(long bytesOutCounter) {
        this.bytesOutCounter = bytesOutCounter;
    }

    public void setMsgOutCounter(long msgOutCounter) {
        this.msgOutCounter = msgOutCounter;
    }

    public void setMsgRateRedeliver(double msgRateRedeliver) {
        this.msgRateRedeliver = msgRateRedeliver;
    }

    public void setMessageAckRate(double messageAckRate) {
        this.messageAckRate = messageAckRate;
    }

    public void setChunkedMessageRate(int chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    public void setMsgBacklog(long msgBacklog) {
        this.msgBacklog = msgBacklog;
    }

    public void setBacklogSize(long backlogSize) {
        this.backlogSize = backlogSize;
    }

    public void setEarliestMsgPublishTimeInBacklog(long earliestMsgPublishTimeInBacklog) {
        this.earliestMsgPublishTimeInBacklog = earliestMsgPublishTimeInBacklog;
    }

    public void setMsgBacklogNoDelayed(long msgBacklogNoDelayed) {
        this.msgBacklogNoDelayed = msgBacklogNoDelayed;
    }

    public void setBlockedSubscriptionOnUnackedMsgs(boolean blockedSubscriptionOnUnackedMsgs) {
        this.blockedSubscriptionOnUnackedMsgs = blockedSubscriptionOnUnackedMsgs;
    }

    public void setMsgDelayed(long msgDelayed) {
        this.msgDelayed = msgDelayed;
    }

    public void setUnackedMessages(long unackedMessages) {
        this.unackedMessages = unackedMessages;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setActiveConsumerName(String activeConsumerName) {
        this.activeConsumerName = activeConsumerName;
    }

    public void setMsgRateExpired(double msgRateExpired) {
        this.msgRateExpired = msgRateExpired;
    }

    public void setTotalMsgExpired(long totalMsgExpired) {
        this.totalMsgExpired = totalMsgExpired;
    }

    public void setLastExpireTimestamp(long lastExpireTimestamp) {
        this.lastExpireTimestamp = lastExpireTimestamp;
    }

    public void setLastConsumedFlowTimestamp(long lastConsumedFlowTimestamp) {
        this.lastConsumedFlowTimestamp = lastConsumedFlowTimestamp;
    }

    public void setLastConsumedTimestamp(long lastConsumedTimestamp) {
        this.lastConsumedTimestamp = lastConsumedTimestamp;
    }

    public void setLastAckedTimestamp(long lastAckedTimestamp) {
        this.lastAckedTimestamp = lastAckedTimestamp;
    }

    public void setLastMarkDeleteAdvancedTimestamp(long lastMarkDeleteAdvancedTimestamp) {
        this.lastMarkDeleteAdvancedTimestamp = lastMarkDeleteAdvancedTimestamp;
    }

    public void setConsumers(List<ConsumerStatsImpl> consumers) {
        this.consumers = consumers;
    }

    public void setDurable(boolean isDurable) {
        this.isDurable = isDurable;
    }

    public void setReplicated(boolean isReplicated) {
        this.isReplicated = isReplicated;
    }

    public void setAllowOutOfOrderDelivery(boolean allowOutOfOrderDelivery) {
        this.allowOutOfOrderDelivery = allowOutOfOrderDelivery;
    }

    public void setKeySharedMode(String keySharedMode) {
        this.keySharedMode = keySharedMode;
    }

    public void setConsumersAfterMarkDeletePosition(Map<String, String> consumersAfterMarkDeletePosition) {
        this.consumersAfterMarkDeletePosition = consumersAfterMarkDeletePosition;
    }

    public void setNonContiguousDeletedMessagesRanges(int nonContiguousDeletedMessagesRanges) {
        this.nonContiguousDeletedMessagesRanges = nonContiguousDeletedMessagesRanges;
    }

    public void setNonContiguousDeletedMessagesRangesSerializedSize(int nonContiguousDeletedMessagesRangesSerializedSize) {
        this.nonContiguousDeletedMessagesRangesSerializedSize = nonContiguousDeletedMessagesRangesSerializedSize;
    }

    public void setDelayedMessageIndexSizeInBytes(long delayedMessageIndexSizeInBytes) {
        this.delayedMessageIndexSizeInBytes = delayedMessageIndexSizeInBytes;
    }

    @JsonIgnore
    public void setBucketDelayedIndexStats(Map<String, TopicMetricBean> bucketDelayedIndexStats) {
        this.bucketDelayedIndexStats = bucketDelayedIndexStats;
    }

    public void setSubscriptionProperties(Map<String, String> subscriptionProperties) {
        this.subscriptionProperties = subscriptionProperties;
    }

    public void setFilterProcessedMsgCount(long filterProcessedMsgCount) {
        this.filterProcessedMsgCount = filterProcessedMsgCount;
    }

    public void setFilterAcceptedMsgCount(long filterAcceptedMsgCount) {
        this.filterAcceptedMsgCount = filterAcceptedMsgCount;
    }

    public void setFilterRejectedMsgCount(long filterRejectedMsgCount) {
        this.filterRejectedMsgCount = filterRejectedMsgCount;
    }

    public void setFilterRescheduledMsgCount(long filterRescheduledMsgCount) {
        this.filterRescheduledMsgCount = filterRescheduledMsgCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionStatsImpl)) {
            return false;
        }
        SubscriptionStatsImpl other = (SubscriptionStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (this.getBytesOutCounter() != other.getBytesOutCounter()) {
            return false;
        }
        if (this.getMsgOutCounter() != other.getMsgOutCounter()) {
            return false;
        }
        if (Double.compare(this.getMsgRateRedeliver(), other.getMsgRateRedeliver()) != 0) {
            return false;
        }
        if (Double.compare(this.getMessageAckRate(), other.getMessageAckRate()) != 0) {
            return false;
        }
        if (this.getChunkedMessageRate() != other.getChunkedMessageRate()) {
            return false;
        }
        if (this.getMsgBacklog() != other.getMsgBacklog()) {
            return false;
        }
        if (this.getBacklogSize() != other.getBacklogSize()) {
            return false;
        }
        if (this.getEarliestMsgPublishTimeInBacklog() != other.getEarliestMsgPublishTimeInBacklog()) {
            return false;
        }
        if (this.getMsgBacklogNoDelayed() != other.getMsgBacklogNoDelayed()) {
            return false;
        }
        if (this.isBlockedSubscriptionOnUnackedMsgs() != other.isBlockedSubscriptionOnUnackedMsgs()) {
            return false;
        }
        if (this.getMsgDelayed() != other.getMsgDelayed()) {
            return false;
        }
        if (this.getUnackedMessages() != other.getUnackedMessages()) {
            return false;
        }
        if (Double.compare(this.getMsgRateExpired(), other.getMsgRateExpired()) != 0) {
            return false;
        }
        if (this.getTotalMsgExpired() != other.getTotalMsgExpired()) {
            return false;
        }
        if (this.getLastExpireTimestamp() != other.getLastExpireTimestamp()) {
            return false;
        }
        if (this.getLastConsumedFlowTimestamp() != other.getLastConsumedFlowTimestamp()) {
            return false;
        }
        if (this.getLastConsumedTimestamp() != other.getLastConsumedTimestamp()) {
            return false;
        }
        if (this.getLastAckedTimestamp() != other.getLastAckedTimestamp()) {
            return false;
        }
        if (this.getLastMarkDeleteAdvancedTimestamp() != other.getLastMarkDeleteAdvancedTimestamp()) {
            return false;
        }
        if (this.isDurable() != other.isDurable()) {
            return false;
        }
        if (this.isReplicated() != other.isReplicated()) {
            return false;
        }
        if (this.isAllowOutOfOrderDelivery() != other.isAllowOutOfOrderDelivery()) {
            return false;
        }
        if (this.getNonContiguousDeletedMessagesRanges() != other.getNonContiguousDeletedMessagesRanges()) {
            return false;
        }
        if (this.getNonContiguousDeletedMessagesRangesSerializedSize() != other.getNonContiguousDeletedMessagesRangesSerializedSize()) {
            return false;
        }
        if (this.getDelayedMessageIndexSizeInBytes() != other.getDelayedMessageIndexSizeInBytes()) {
            return false;
        }
        if (this.getFilterProcessedMsgCount() != other.getFilterProcessedMsgCount()) {
            return false;
        }
        if (this.getFilterAcceptedMsgCount() != other.getFilterAcceptedMsgCount()) {
            return false;
        }
        if (this.getFilterRejectedMsgCount() != other.getFilterRejectedMsgCount()) {
            return false;
        }
        if (this.getFilterRescheduledMsgCount() != other.getFilterRescheduledMsgCount()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$activeConsumerName = this.getActiveConsumerName();
        String other$activeConsumerName = other.getActiveConsumerName();
        if (this$activeConsumerName == null ? other$activeConsumerName != null : !this$activeConsumerName.equals(other$activeConsumerName)) {
            return false;
        }
        List<ConsumerStatsImpl> this$consumers = this.getConsumers();
        List<ConsumerStatsImpl> other$consumers = other.getConsumers();
        if (this$consumers == null ? other$consumers != null : !((Object)this$consumers).equals(other$consumers)) {
            return false;
        }
        String this$keySharedMode = this.getKeySharedMode();
        String other$keySharedMode = other.getKeySharedMode();
        if (this$keySharedMode == null ? other$keySharedMode != null : !this$keySharedMode.equals(other$keySharedMode)) {
            return false;
        }
        Map<String, String> this$consumersAfterMarkDeletePosition = this.getConsumersAfterMarkDeletePosition();
        Map<String, String> other$consumersAfterMarkDeletePosition = other.getConsumersAfterMarkDeletePosition();
        if (this$consumersAfterMarkDeletePosition == null ? other$consumersAfterMarkDeletePosition != null : !((Object)this$consumersAfterMarkDeletePosition).equals(other$consumersAfterMarkDeletePosition)) {
            return false;
        }
        Map<String, TopicMetricBean> this$bucketDelayedIndexStats = this.getBucketDelayedIndexStats();
        Map<String, TopicMetricBean> other$bucketDelayedIndexStats = other.getBucketDelayedIndexStats();
        if (this$bucketDelayedIndexStats == null ? other$bucketDelayedIndexStats != null : !((Object)this$bucketDelayedIndexStats).equals(other$bucketDelayedIndexStats)) {
            return false;
        }
        Map<String, String> this$subscriptionProperties = this.getSubscriptionProperties();
        Map<String, String> other$subscriptionProperties = other.getSubscriptionProperties();
        return !(this$subscriptionProperties == null ? other$subscriptionProperties != null : !((Object)this$subscriptionProperties).equals(other$subscriptionProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $bytesOutCounter = this.getBytesOutCounter();
        result = result * 59 + (int)($bytesOutCounter >>> 32 ^ $bytesOutCounter);
        long $msgOutCounter = this.getMsgOutCounter();
        result = result * 59 + (int)($msgOutCounter >>> 32 ^ $msgOutCounter);
        long $msgRateRedeliver = Double.doubleToLongBits(this.getMsgRateRedeliver());
        result = result * 59 + (int)($msgRateRedeliver >>> 32 ^ $msgRateRedeliver);
        long $messageAckRate = Double.doubleToLongBits(this.getMessageAckRate());
        result = result * 59 + (int)($messageAckRate >>> 32 ^ $messageAckRate);
        result = result * 59 + this.getChunkedMessageRate();
        long $msgBacklog = this.getMsgBacklog();
        result = result * 59 + (int)($msgBacklog >>> 32 ^ $msgBacklog);
        long $backlogSize = this.getBacklogSize();
        result = result * 59 + (int)($backlogSize >>> 32 ^ $backlogSize);
        long $earliestMsgPublishTimeInBacklog = this.getEarliestMsgPublishTimeInBacklog();
        result = result * 59 + (int)($earliestMsgPublishTimeInBacklog >>> 32 ^ $earliestMsgPublishTimeInBacklog);
        long $msgBacklogNoDelayed = this.getMsgBacklogNoDelayed();
        result = result * 59 + (int)($msgBacklogNoDelayed >>> 32 ^ $msgBacklogNoDelayed);
        result = result * 59 + (this.isBlockedSubscriptionOnUnackedMsgs() ? 79 : 97);
        long $msgDelayed = this.getMsgDelayed();
        result = result * 59 + (int)($msgDelayed >>> 32 ^ $msgDelayed);
        long $unackedMessages = this.getUnackedMessages();
        result = result * 59 + (int)($unackedMessages >>> 32 ^ $unackedMessages);
        long $msgRateExpired = Double.doubleToLongBits(this.getMsgRateExpired());
        result = result * 59 + (int)($msgRateExpired >>> 32 ^ $msgRateExpired);
        long $totalMsgExpired = this.getTotalMsgExpired();
        result = result * 59 + (int)($totalMsgExpired >>> 32 ^ $totalMsgExpired);
        long $lastExpireTimestamp = this.getLastExpireTimestamp();
        result = result * 59 + (int)($lastExpireTimestamp >>> 32 ^ $lastExpireTimestamp);
        long $lastConsumedFlowTimestamp = this.getLastConsumedFlowTimestamp();
        result = result * 59 + (int)($lastConsumedFlowTimestamp >>> 32 ^ $lastConsumedFlowTimestamp);
        long $lastConsumedTimestamp = this.getLastConsumedTimestamp();
        result = result * 59 + (int)($lastConsumedTimestamp >>> 32 ^ $lastConsumedTimestamp);
        long $lastAckedTimestamp = this.getLastAckedTimestamp();
        result = result * 59 + (int)($lastAckedTimestamp >>> 32 ^ $lastAckedTimestamp);
        long $lastMarkDeleteAdvancedTimestamp = this.getLastMarkDeleteAdvancedTimestamp();
        result = result * 59 + (int)($lastMarkDeleteAdvancedTimestamp >>> 32 ^ $lastMarkDeleteAdvancedTimestamp);
        result = result * 59 + (this.isDurable() ? 79 : 97);
        result = result * 59 + (this.isReplicated() ? 79 : 97);
        result = result * 59 + (this.isAllowOutOfOrderDelivery() ? 79 : 97);
        result = result * 59 + this.getNonContiguousDeletedMessagesRanges();
        result = result * 59 + this.getNonContiguousDeletedMessagesRangesSerializedSize();
        long $delayedMessageIndexSizeInBytes = this.getDelayedMessageIndexSizeInBytes();
        result = result * 59 + (int)($delayedMessageIndexSizeInBytes >>> 32 ^ $delayedMessageIndexSizeInBytes);
        long $filterProcessedMsgCount = this.getFilterProcessedMsgCount();
        result = result * 59 + (int)($filterProcessedMsgCount >>> 32 ^ $filterProcessedMsgCount);
        long $filterAcceptedMsgCount = this.getFilterAcceptedMsgCount();
        result = result * 59 + (int)($filterAcceptedMsgCount >>> 32 ^ $filterAcceptedMsgCount);
        long $filterRejectedMsgCount = this.getFilterRejectedMsgCount();
        result = result * 59 + (int)($filterRejectedMsgCount >>> 32 ^ $filterRejectedMsgCount);
        long $filterRescheduledMsgCount = this.getFilterRescheduledMsgCount();
        result = result * 59 + (int)($filterRescheduledMsgCount >>> 32 ^ $filterRescheduledMsgCount);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $activeConsumerName = this.getActiveConsumerName();
        result = result * 59 + ($activeConsumerName == null ? 43 : $activeConsumerName.hashCode());
        List<ConsumerStatsImpl> $consumers = this.getConsumers();
        result = result * 59 + ($consumers == null ? 43 : ((Object)$consumers).hashCode());
        String $keySharedMode = this.getKeySharedMode();
        result = result * 59 + ($keySharedMode == null ? 43 : $keySharedMode.hashCode());
        Map<String, String> $consumersAfterMarkDeletePosition = this.getConsumersAfterMarkDeletePosition();
        result = result * 59 + ($consumersAfterMarkDeletePosition == null ? 43 : ((Object)$consumersAfterMarkDeletePosition).hashCode());
        Map<String, TopicMetricBean> $bucketDelayedIndexStats = this.getBucketDelayedIndexStats();
        result = result * 59 + ($bucketDelayedIndexStats == null ? 43 : ((Object)$bucketDelayedIndexStats).hashCode());
        Map<String, String> $subscriptionProperties = this.getSubscriptionProperties();
        result = result * 59 + ($subscriptionProperties == null ? 43 : ((Object)$subscriptionProperties).hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionStatsImpl(msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesOutCounter=" + this.getBytesOutCounter() + ", msgOutCounter=" + this.getMsgOutCounter() + ", msgRateRedeliver=" + this.getMsgRateRedeliver() + ", messageAckRate=" + this.getMessageAckRate() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", msgBacklog=" + this.getMsgBacklog() + ", backlogSize=" + this.getBacklogSize() + ", earliestMsgPublishTimeInBacklog=" + this.getEarliestMsgPublishTimeInBacklog() + ", msgBacklogNoDelayed=" + this.getMsgBacklogNoDelayed() + ", blockedSubscriptionOnUnackedMsgs=" + this.isBlockedSubscriptionOnUnackedMsgs() + ", msgDelayed=" + this.getMsgDelayed() + ", unackedMessages=" + this.getUnackedMessages() + ", type=" + this.getType() + ", activeConsumerName=" + this.getActiveConsumerName() + ", msgRateExpired=" + this.getMsgRateExpired() + ", totalMsgExpired=" + this.getTotalMsgExpired() + ", lastExpireTimestamp=" + this.getLastExpireTimestamp() + ", lastConsumedFlowTimestamp=" + this.getLastConsumedFlowTimestamp() + ", lastConsumedTimestamp=" + this.getLastConsumedTimestamp() + ", lastAckedTimestamp=" + this.getLastAckedTimestamp() + ", lastMarkDeleteAdvancedTimestamp=" + this.getLastMarkDeleteAdvancedTimestamp() + ", consumers=" + this.getConsumers() + ", isDurable=" + this.isDurable() + ", isReplicated=" + this.isReplicated() + ", allowOutOfOrderDelivery=" + this.isAllowOutOfOrderDelivery() + ", keySharedMode=" + this.getKeySharedMode() + ", consumersAfterMarkDeletePosition=" + this.getConsumersAfterMarkDeletePosition() + ", nonContiguousDeletedMessagesRanges=" + this.getNonContiguousDeletedMessagesRanges() + ", nonContiguousDeletedMessagesRangesSerializedSize=" + this.getNonContiguousDeletedMessagesRangesSerializedSize() + ", delayedMessageIndexSizeInBytes=" + this.getDelayedMessageIndexSizeInBytes() + ", bucketDelayedIndexStats=" + this.getBucketDelayedIndexStats() + ", subscriptionProperties=" + this.getSubscriptionProperties() + ", filterProcessedMsgCount=" + this.getFilterProcessedMsgCount() + ", filterAcceptedMsgCount=" + this.getFilterAcceptedMsgCount() + ", filterRejectedMsgCount=" + this.getFilterRejectedMsgCount() + ", filterRescheduledMsgCount=" + this.getFilterRescheduledMsgCount() + ")";
    }
}

