/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pulsar.shade.org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.pulsar.shade.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class INIConfiguration
extends AbstractFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";

    public INIConfiguration() {
    }

    public INIConfiguration(String filename) throws ConfigurationException {
        super(filename);
    }

    public INIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public INIConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter out = new PrintWriter(writer);
        for (String section : this.getSections()) {
            out.print("[");
            out.print(section);
            out.print("]");
            out.println();
            Configuration subset = this.subset(section);
            Iterator<String> keys = subset.getKeys();
            while (keys.hasNext()) {
                String key = keys.next();
                Object value2 = subset.getProperty(key);
                if (value2 instanceof Collection) {
                    for (Object value2 : (Collection)value2) {
                        out.print(key);
                        out.print(" = ");
                        out.print(this.formatValue(value2.toString()));
                        out.println();
                    }
                    continue;
                }
                out.print(key);
                out.print(" = ");
                out.print(this.formatValue(value2.toString()));
                out.println();
            }
            out.println();
        }
        out.flush();
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            String section = "";
            while (line != null) {
                if (!this.isCommentLine(line = line.trim())) {
                    if (this.isSectionLine(line)) {
                        section = line.substring(1, line.length() - 1) + ".";
                    } else {
                        String key = "";
                        String value = "";
                        int index = line.indexOf("=");
                        if (index >= 0) {
                            key = section + line.substring(0, index);
                            value = this.parseValue(line.substring(index + 1));
                        } else {
                            index = line.indexOf(":");
                            if (index >= 0) {
                                key = section + line.substring(0, index);
                                value = this.parseValue(line.substring(index + 1));
                            } else {
                                key = section + line;
                            }
                        }
                        this.addProperty(key.trim(), value);
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    private String parseValue(String value) {
        boolean quoted = (value = value.trim()).startsWith("\"") || value.startsWith("'");
        boolean stop = false;
        boolean escape = false;
        char quote = quoted ? value.charAt(0) : (char)'\u0000';
        StringBuilder result = new StringBuilder();
        for (int i = quoted ? 1 : 0; i < value.length() && !stop; ++i) {
            char c = value.charAt(i);
            if (quoted) {
                if ('\\' == c && !escape) {
                    escape = true;
                    continue;
                }
                if (!escape && quote == c) {
                    stop = true;
                    continue;
                }
                if (escape && quote == c) {
                    escape = false;
                    result.append(c);
                    continue;
                }
                if (escape) {
                    escape = false;
                    result.append('\\');
                }
                result.append(c);
                continue;
            }
            if (COMMENT_CHARS.indexOf(c) == -1) {
                result.append(c);
                continue;
            }
            stop = true;
        }
        String v = result.toString();
        if (!quoted) {
            v = v.trim();
        }
        return v;
    }

    private String formatValue(String value) {
        boolean quoted = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !quoted; ++i) {
            char c = COMMENT_CHARS.charAt(i);
            if (value.indexOf(c) == -1) continue;
            quoted = true;
        }
        if (quoted) {
            return '\"' + value.replaceAll("\"", "\\\\\\\"") + '\"';
        }
        return value;
    }

    protected boolean isCommentLine(String line) {
        if (line == null) {
            return false;
        }
        return line.length() < 1 || COMMENT_CHARS.indexOf(line.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith("[") && line.endsWith("]");
    }

    public Set<String> getSections() {
        TreeSet<String> sections = new TreeSet<String>();
        Iterator<String> keys = this.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            int index = key.indexOf(".");
            if (index < 0) continue;
            sections.add(key.substring(0, index));
        }
        return sections;
    }
}

