/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Security;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.pulsar.shade.io.netty.resolver.AddressResolver;
import org.apache.pulsar.shade.io.netty.resolver.DefaultNameResolver;
import org.apache.pulsar.shade.io.netty.resolver.InetNameResolver;
import org.apache.pulsar.shade.io.netty.resolver.InetSocketAddressResolver;
import org.apache.pulsar.shade.io.netty.resolver.NameResolver;
import org.apache.pulsar.shade.io.netty.resolver.dns.DnsNameResolverBuilder;
import org.apache.pulsar.shade.io.netty.util.concurrent.EventExecutor;
import org.apache.pulsar.shade.io.netty.util.concurrent.GenericFutureListener;
import org.apache.pulsar.shade.io.netty.util.concurrent.ImmediateEventExecutor;
import org.apache.pulsar.shade.io.netty.util.concurrent.Promise;
import org.apache.pulsar.shade.org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsResolverUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DnsResolverUtil.class);
    private static final String CACHE_POLICY_PROP = "networkaddress.cache.ttl";
    private static final String CACHE_POLICY_PROP_FALLBACK = "sun.net.inetaddr.ttl";
    private static final String NEGATIVE_CACHE_POLICY_PROP = "networkaddress.cache.negative.ttl";
    private static final String NEGATIVE_CACHE_POLICY_PROP_FALLBACK = "sun.net.inetaddr.negative.ttl";
    private static final int JDK_DEFAULT_TTL = 30;
    private static final int MIN_TTL = 0;
    private static final int TTL;
    private static final int NEGATIVE_TTL;
    private static final int DEFAULT_TTL = 60;
    private static final int DEFAULT_NEGATIVE_TTL = 10;

    private DnsResolverUtil() {
    }

    public static void applyJdkDnsCacheSettings(DnsNameResolverBuilder dnsNameResolverBuilder) {
        dnsNameResolverBuilder.ttl(0, TTL);
        dnsNameResolverBuilder.negativeTtl(NEGATIVE_TTL);
    }

    public static int getDefaultMinTTL() {
        return 0;
    }

    public static int getDefaultTTL() {
        return TTL;
    }

    public static int getDefaultNegativeTTL() {
        return NEGATIVE_TTL;
    }

    public static NameResolver<InetAddress> adaptToNameResolver(AddressResolver<InetSocketAddress> addressResolver) {
        if (addressResolver == null) {
            return new DefaultNameResolver(ImmediateEventExecutor.INSTANCE);
        }
        if (InetSocketAddressResolver.class.isInstance(addressResolver)) {
            try {
                Field nameResolverField = FieldUtils.getDeclaredField(InetSocketAddressResolver.class, "nameResolver", true);
                if (nameResolverField != null) {
                    return (NameResolver)FieldUtils.readField(nameResolverField, addressResolver);
                }
                log.warn("Could not find nameResolver Field in InetSocketAddressResolver instance.");
            }
            catch (Throwable t) {
                log.warn("Failed to extract NameResolver from InetSocketAddressResolver instance. {}", (Object)t.getMessage());
            }
        }
        log.info("Creating NameResolver adapter that wraps an AddressResolver instance.");
        return DnsResolverUtil.createNameResolverAdapter(addressResolver, ImmediateEventExecutor.INSTANCE);
    }

    static NameResolver<InetAddress> createNameResolverAdapter(final AddressResolver<InetSocketAddress> addressResolver, EventExecutor executor) {
        return new InetNameResolver(executor){

            @Override
            protected void doResolve(String inetHost, final Promise<InetAddress> promise) throws Exception {
                Promise<InetSocketAddress> delegatedPromise = this.executor().newPromise();
                addressResolver.resolve(InetSocketAddress.createUnresolved(inetHost, 1), delegatedPromise);
                delegatedPromise.addListener(new GenericFutureListener<Promise<InetSocketAddress>>(){

                    @Override
                    public void operationComplete(Promise<InetSocketAddress> future) throws Exception {
                        if (future.isSuccess()) {
                            promise.setSuccess(((InetSocketAddress)future.get()).getAddress());
                        } else {
                            promise.setFailure(future.cause());
                        }
                    }
                });
            }

            @Override
            protected void doResolveAll(String inetHost, final Promise<List<InetAddress>> promise) throws Exception {
                Promise delegatedPromise = this.executor().newPromise();
                addressResolver.resolveAll(InetSocketAddress.createUnresolved(inetHost, 1), delegatedPromise);
                delegatedPromise.addListener(new GenericFutureListener<Promise<List<InetSocketAddress>>>(){

                    @Override
                    public void operationComplete(Promise<List<InetSocketAddress>> future) throws Exception {
                        if (future.isSuccess()) {
                            promise.setSuccess(((List)future.get()).stream().map(InetSocketAddress::getAddress).toList());
                        } else {
                            promise.setFailure(future.cause());
                        }
                    }
                });
            }
        };
    }

    static {
        int ttl = 60;
        int negativeTtl = 10;
        try {
            String negativeTtlStr;
            String ttlStr = Security.getProperty(CACHE_POLICY_PROP);
            if (ttlStr == null) {
                ttlStr = System.getProperty(CACHE_POLICY_PROP_FALLBACK);
            }
            if ((negativeTtlStr = Security.getProperty(NEGATIVE_CACHE_POLICY_PROP)) == null) {
                negativeTtlStr = System.getProperty(NEGATIVE_CACHE_POLICY_PROP_FALLBACK);
            }
            ttl = Optional.ofNullable(ttlStr).map(Integer::decode).filter(i -> i > 0).orElseGet(() -> {
                try {
                    if (System.getSecurityManager() == null) {
                        return 30;
                    }
                }
                catch (Throwable t) {
                    log.warn("Cannot use current logic to resolve JDK default DNS TTL settings. Use sun.net.inetaddr.ttl and sun.net.inetaddr.negative.ttl system properties for setting default values for DNS TTL settings. {}", (Object)t.getMessage());
                }
                return 60;
            });
            negativeTtl = Optional.ofNullable(negativeTtlStr).map(Integer::decode).filter(i -> i >= 0).orElse(10);
        }
        catch (NumberFormatException e) {
            log.warn("Cannot get DNS TTL settings", (Throwable)e);
        }
        TTL = ttl;
        NEGATIVE_TTL = negativeTtl;
    }
}

