/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.util.Map;
import net.jodah.typetools.TypeResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.functions.CryptoConfig;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.api.Function;
import org.apache.pulsar.functions.api.SerDe;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidatorUtils.class);
    private static final String DEFAULT_SERDE = "org.apache.pulsar.functions.api.utils.DefaultSerDe";

    public static void validateSchema(String schemaType, Class<?> typeArg, ClassLoader clsLoader, boolean input) {
        if (!StringUtils.isEmpty((CharSequence)schemaType) && ValidatorUtils.getBuiltinSchemaType(schemaType) == null) {
            ClassLoaderUtils.implementsClass((String)schemaType, Schema.class, (ClassLoader)clsLoader);
            ValidatorUtils.validateSchemaType(schemaType, typeArg, clsLoader, input);
        }
    }

    private static SchemaType getBuiltinSchemaType(String schemaTypeOrClassName) {
        try {
            return SchemaType.valueOf((String)schemaTypeOrClassName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void validateCryptoKeyReader(CryptoConfig conf, ClassLoader classLoader, boolean isProducer) {
        Class cryptoClass;
        if (StringUtils.isEmpty((CharSequence)conf.getCryptoKeyReaderClassName())) {
            return;
        }
        try {
            cryptoClass = ClassLoaderUtils.loadClass((String)conf.getCryptoKeyReaderClassName(), (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("The crypto key reader class %s does not exist", conf.getCryptoKeyReaderClassName()));
        }
        ClassLoaderUtils.implementsClass((String)conf.getCryptoKeyReaderClassName(), CryptoKeyReader.class, (ClassLoader)classLoader);
        try {
            cryptoClass.getConstructor(Map.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(String.format("The crypto key reader class %s does not implement the desired constructor.", conf.getCryptoKeyReaderClassName()));
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Failed to access crypto key reader class", e);
        }
        if (isProducer && (conf.getEncryptionKeys() == null || conf.getEncryptionKeys().length == 0)) {
            throw new IllegalArgumentException("Missing encryption key name for producer crypto key reader");
        }
    }

    public static void validateSerde(String inputSerializer, Class<?> typeArg, ClassLoader clsLoader, boolean deser) {
        Class<?> serdeInputClass;
        Class<?> fnInputClass;
        if (StringUtils.isEmpty((CharSequence)inputSerializer)) {
            return;
        }
        if (inputSerializer.equals(DEFAULT_SERDE)) {
            return;
        }
        try {
            Class clazz = ClassLoaderUtils.loadClass((String)inputSerializer, (ClassLoader)clsLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("The input serialization/deserialization class %s does not exist", inputSerializer));
        }
        ClassLoaderUtils.implementsClass((String)inputSerializer, SerDe.class, (ClassLoader)clsLoader);
        SerDe serDe = (SerDe)Reflections.createInstance((String)inputSerializer, (ClassLoader)clsLoader);
        if (serDe == null) {
            throw new IllegalArgumentException(String.format("The SerDe class %s does not exist", inputSerializer));
        }
        Class[] serDeTypes = TypeResolver.resolveRawArguments(SerDe.class, serDe.getClass());
        try {
            fnInputClass = Class.forName(typeArg.getName(), true, clsLoader);
            serdeInputClass = Class.forName(serDeTypes[0].getName(), true, clsLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException("Failed to load type class", e);
        }
        if (deser ? !fnInputClass.isAssignableFrom(serdeInputClass) : !serdeInputClass.isAssignableFrom(fnInputClass)) {
            throw new IllegalArgumentException("Serializer type mismatch " + typeArg + " vs " + serDeTypes[0]);
        }
    }

    private static void validateSchemaType(String schemaClassName, Class<?> typeArg, ClassLoader clsLoader, boolean input) {
        Class<?> schemaInputClass;
        Class<?> fnInputClass;
        Schema schema = (Schema)Reflections.createInstance((String)schemaClassName, (ClassLoader)clsLoader);
        if (schema == null) {
            throw new IllegalArgumentException(String.format("The Schema class %s does not exist", schemaClassName));
        }
        Class[] schemaTypes = TypeResolver.resolveRawArguments(Schema.class, schema.getClass());
        try {
            fnInputClass = Class.forName(typeArg.getName(), true, clsLoader);
            schemaInputClass = Class.forName(schemaTypes[0].getName(), true, clsLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException("Failed to load type class", e);
        }
        if (input ? !fnInputClass.isAssignableFrom(schemaInputClass) : !schemaInputClass.isAssignableFrom(fnInputClass)) {
            throw new IllegalArgumentException("Schema type mismatch " + typeArg + " vs " + schemaTypes[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void validateFunctionClassTypes(ClassLoader classLoader, Function.FunctionDetails.Builder functionDetailsBuilder) {
        if (classLoader == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)functionDetailsBuilder.getClassName())) {
            throw new IllegalArgumentException("Function class-name can't be empty");
        }
        try {
            functionClass = classLoader.loadClass(functionDetailsBuilder.getClassName());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("Function class %s must be in class path", new Object[]{functionDetailsBuilder.getClassName()}), e);
        }
        typeArgs = FunctionCommon.getFunctionTypes(functionClass, false);
        if (!Function.class.isAssignableFrom(functionClass) && !java.util.function.Function.class.isAssignableFrom(functionClass)) {
            throw new RuntimeException("User class must either be Function or java.util.Function");
        }
        if (functionDetailsBuilder.hasSource() && functionDetailsBuilder.getSource() != null && StringUtils.isNotBlank((CharSequence)functionDetailsBuilder.getSource().getClassName())) {
            try {
                sourceClassName = functionDetailsBuilder.getSource().getClassName();
                argClassName = FunctionCommon.getTypeArg(sourceClassName, Source.class, classLoader).getName();
                functionDetailsBuilder.setSource(functionDetailsBuilder.getSourceBuilder().setTypeClassName(argClassName));
                if (functionDetailsBuilder.hasSink() && !StringUtils.isBlank((CharSequence)functionDetailsBuilder.getSink().getClassName())) ** GOTO lbl31
                functionDetailsBuilder.setSink(functionDetailsBuilder.getSinkBuilder().setTypeClassName(argClassName));
            }
            catch (IllegalArgumentException ie) {
                throw ie;
            }
            catch (Exception e) {
                ValidatorUtils.log.error("Failed to validate source class", (Throwable)e);
                throw new IllegalArgumentException("Failed to validate source class-name", e);
            }
        } else if (StringUtils.isBlank((CharSequence)functionDetailsBuilder.getSourceBuilder().getTypeClassName())) {
            functionDetailsBuilder.setSource(functionDetailsBuilder.getSourceBuilder().setTypeClassName(typeArgs[0].getName()));
        }
lbl31:
        // 5 sources

        if (functionDetailsBuilder.hasSink() && functionDetailsBuilder.getSink() != null && StringUtils.isNotBlank((CharSequence)functionDetailsBuilder.getSink().getClassName())) {
            try {
                sinkClassName = functionDetailsBuilder.getSink().getClassName();
                argClassName = FunctionCommon.getTypeArg(sinkClassName, Sink.class, classLoader).getName();
                functionDetailsBuilder.setSink(functionDetailsBuilder.getSinkBuilder().setTypeClassName(argClassName));
                if (functionDetailsBuilder.hasSource() && !StringUtils.isBlank((CharSequence)functionDetailsBuilder.getSource().getClassName())) ** GOTO lbl49
                functionDetailsBuilder.setSource(functionDetailsBuilder.getSourceBuilder().setTypeClassName(argClassName));
            }
            catch (IllegalArgumentException ie) {
                throw ie;
            }
            catch (Exception e) {
                ValidatorUtils.log.error("Failed to validate sink class", (Throwable)e);
                throw new IllegalArgumentException("Failed to validate sink class-name", e);
            }
        } else if (StringUtils.isBlank((CharSequence)functionDetailsBuilder.getSinkBuilder().getTypeClassName())) {
            functionDetailsBuilder.setSink(functionDetailsBuilder.getSinkBuilder().setTypeClassName(typeArgs[1].getName()));
        }
lbl49:
        // 5 sources

    }
}

