/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch;

import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomExponentialRetry {
    private static final Logger log = LoggerFactory.getLogger(RandomExponentialRetry.class);
    public static final RandomExponentialRetry INSTANCE = new RandomExponentialRetry();
    public final long maxRetryTimeInSec;

    public RandomExponentialRetry() {
        this(TimeUnit.HOURS.toSeconds(24L));
    }

    public RandomExponentialRetry(long maxRetryTimeInSec) {
        this.maxRetryTimeInSec = maxRetryTimeInSec;
    }

    public long waitInMs(int attempt, long backoffInMs) {
        assert (attempt >= 0);
        assert (backoffInMs >= 0L);
        return Math.min(this.maxRetryTimeInSec * 1000L, backoffInMs << attempt);
    }

    public long randomWaitInMs(int attempt, long backoffInMs) {
        return ThreadLocalRandom.current().nextLong(0L, this.waitInMs(attempt, backoffInMs));
    }

    public <T> T retry(Callable<T> function, int maxAttempts, long initialBackoff, String source) throws Exception {
        return this.retry(function, maxAttempts, initialBackoff, source, new Time());
    }

    protected <T> T retry(Callable<T> function, int maxAttempts, long initialBackoff, String source, Time clock) throws Exception {
        Exception lastException = null;
        for (int i = 0; i < maxAttempts || maxAttempts == -1; ++i) {
            try {
                return function.call();
            }
            catch (Exception e) {
                lastException = e;
                long backoff = this.randomWaitInMs(i, initialBackoff);
                log.info("Executing '{}', attempt {}/{}, next retry in {} ms, caused by: {}", new Object[]{source, i, maxAttempts, backoff, e.getMessage()});
                clock.sleep(backoff);
                continue;
            }
        }
        throw lastException;
    }

    public static class Time {
        void sleep(long millis) throws InterruptedException {
            Thread.sleep(millis);
        }
    }
}

