/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtonFactoryLoader<C> {
    private static final Logger LOGGER = Logger.getLogger(ProtonFactoryLoader.class.getName());
    private Class<C> _factoryInterface;

    public ProtonFactoryLoader() {
    }

    public ProtonFactoryLoader(Class<C> factoryInterface) {
        this._factoryInterface = factoryInterface;
    }

    public C loadFactory() {
        return this.loadFactory(this._factoryInterface);
    }

    public C loadFactory(Class<C> factoryInterface) {
        if (factoryInterface == null) {
            throw new IllegalStateException("factoryInterface has not been set.");
        }
        ServiceLoader<C> serviceLoader = ServiceLoader.load(factoryInterface);
        Iterator<C> serviceLoaderIterator = serviceLoader.iterator();
        if (!serviceLoaderIterator.hasNext()) {
            throw new IllegalStateException("Can't find service loader for " + factoryInterface.getName());
        }
        C factory = serviceLoaderIterator.next();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("loadFactory returning " + factory);
        }
        return factory;
    }
}

