/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.apache.qpid.amqp_1_0.jms.BytesMessage;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage {
    private DataInputStream _dataAsInput;
    private DataOutputStream _dataAsOutput;
    private ByteArrayOutputStream _bytesOut;
    private Data _dataIn;

    protected BytesMessageImpl(Header header, DeliveryAnnotations deliveryAnnotations, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, Data data, Footer footer, SessionImpl session) {
        super(header, deliveryAnnotations, messageAnnotations, properties, appProperties, footer, session);
        this._dataIn = data;
        Binary dataBuffer = data.getValue();
        this._dataAsInput = new DataInputStream(new ByteArrayInputStream(dataBuffer.getArray(), dataBuffer.getArrayOffset(), dataBuffer.getLength()));
    }

    protected BytesMessageImpl(SessionImpl session) {
        super(new Header(), new DeliveryAnnotations(new HashMap()), new MessageAnnotations(new HashMap()), new Properties(), new ApplicationProperties(new HashMap()), new Footer(Collections.EMPTY_MAP), session);
        this._bytesOut = new ByteArrayOutputStream();
        this._dataAsOutput = new DataOutputStream(this._bytesOut);
    }

    private Data getDataSection() {
        if (this._bytesOut != null) {
            return new Data(new Binary(this._bytesOut.toByteArray()));
        }
        return this._dataIn;
    }

    @Override
    protected boolean isReadOnly() {
        return this._dataIn != null;
    }

    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this.getDataSection().getValue().getLength();
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readBoolean();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readByte();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readUnsignedByte();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public short readShort() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readShort();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readUnsignedShort();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public char readChar() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readChar();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public int readInt() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readInt();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public long readLong() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readLong();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readFloat();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readDouble();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public String readUTF() throws JMSException {
        this.checkReadable();
        try {
            return this._dataAsInput.readUTF();
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public int readBytes(byte[] bytes) throws JMSException {
        return this.readBytes(bytes, bytes.length);
    }

    public int readBytes(byte[] bytes, int length) throws JMSException {
        this.checkReadable();
        try {
            int offset;
            int read;
            for (offset = 0; offset < length && (read = this._dataAsInput.read(bytes, offset, length - offset)) >= 0; offset += read) {
            }
            if (offset == 0 && length != 0) {
                return -1;
            }
            return offset;
        }
        catch (IOException e) {
            throw this.handleInputException(e);
        }
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeBoolean(b);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeByte(b);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeShort(i);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeChar(c);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeInt(i);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeLong(l);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeFloat(v);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeDouble(v);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeUTF(String s) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.writeUTF(s);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.write(bytes);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeBytes(byte[] bytes, int off, int len) throws JMSException {
        this.checkWritable();
        try {
            this._dataAsOutput.write(bytes, off, len);
        }
        catch (IOException e) {
            throw this.handleOutputException(e);
        }
    }

    public void writeObject(Object o) throws JMSException {
        this.checkWritable();
        if (o == null) {
            throw new NullPointerException("Value passed to BytesMessage.writeObject() must be non null");
        }
        if (o instanceof Boolean) {
            this.writeBoolean((Boolean)o);
        } else if (o instanceof Byte) {
            this.writeByte((Byte)o);
        } else if (o instanceof Short) {
            this.writeShort((Short)o);
        } else if (o instanceof Character) {
            this.writeChar(((Character)o).charValue());
        } else if (o instanceof Integer) {
            this.writeInt((Integer)o);
        } else if (o instanceof Long) {
            this.writeLong((Long)o);
        } else if (o instanceof Float) {
            this.writeFloat(((Float)o).floatValue());
        } else if (o instanceof Double) {
            this.writeDouble((Double)o);
        } else if (o instanceof String) {
            this.writeUTF((String)o);
        } else if (o instanceof byte[]) {
            this.writeBytes((byte[])o);
        } else {
            throw new MessageFormatException("Value passed to BytesMessage.writeObject() must be of primitive type.  Type passed was " + o.getClass().getName());
        }
    }

    @Override
    public void reset() throws JMSException {
        if (this._bytesOut != null) {
            byte[] data = this._bytesOut.toByteArray();
            this._dataIn = new Data(new Binary(data));
            this._dataAsInput = new DataInputStream(new ByteArrayInputStream(data));
            this._dataAsOutput = null;
            this._bytesOut = null;
        } else {
            Binary dataBuffer = this._dataIn.getValue();
            this._dataAsInput = new DataInputStream(new ByteArrayInputStream(dataBuffer.getArray(), dataBuffer.getArrayOffset(), dataBuffer.getLength()));
        }
    }

    private JMSException handleInputException(IOException e) {
        MessageEOFException ex = e instanceof EOFException ? new MessageEOFException(e.getMessage()) : new MessageFormatException(e.getMessage());
        ex.initCause((Throwable)e);
        ex.setLinkedException((Exception)e);
        return ex;
    }

    private JMSException handleOutputException(IOException e) {
        JMSException ex = new JMSException(e.getMessage());
        ex.initCause((Throwable)e);
        ex.setLinkedException((Exception)e);
        return ex;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._bytesOut = new ByteArrayOutputStream();
        this._dataAsOutput = new DataOutputStream(this._bytesOut);
        this._dataAsInput = null;
        this._dataIn = null;
    }

    @Override
    Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.add((Section)this.getHeader());
        if (this.getDeliveryAnnotations() != null && this.getDeliveryAnnotations().getValue() != null && !this.getDeliveryAnnotations().getValue().isEmpty()) {
            sections.add((Section)this.getDeliveryAnnotations());
        }
        if (this.getMessageAnnotations() != null && this.getMessageAnnotations().getValue() != null && !this.getMessageAnnotations().getValue().isEmpty()) {
            sections.add((Section)this.getMessageAnnotations());
        }
        sections.add((Section)this.getProperties());
        sections.add((Section)this.getApplicationProperties());
        sections.add((Section)this.getDataSection());
        sections.add((Section)this.getFooter());
        return sections;
    }
}

