/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.amqp_1_0.transport.Delivery;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkListener;
import org.apache.qpid.amqp_1_0.transport.SessionEndpoint;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.transport.Attach;
import org.apache.qpid.amqp_1_0.type.transport.Flow;
import org.apache.qpid.amqp_1_0.type.transport.Role;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class SendingLinkEndpoint
extends LinkEndpoint<SendingLinkListener> {
    private UnsignedInteger _lastDeliveryId;
    private Binary _lastDeliveryTag;
    private Map<Binary, UnsignedInteger> _unsettledMap = new HashMap<Binary, UnsignedInteger>();
    private Binary _transactionId;

    public SendingLinkEndpoint(SessionEndpoint sessionEndpoint, String name) {
        this(sessionEndpoint, name, null);
    }

    public SendingLinkEndpoint(SessionEndpoint sessionEndpoint, String name, Map<Binary, Outcome> unsettled) {
        super(sessionEndpoint, name, unsettled);
        this.init();
    }

    public SendingLinkEndpoint(SessionEndpoint sessionEndpoint, String name, Map<Binary, Outcome> unsettled, DeliveryStateHandler deliveryStateHandler) {
        super(sessionEndpoint, name, unsettled, deliveryStateHandler);
        this.init();
    }

    public SendingLinkEndpoint(SessionEndpoint sessionEndpoint, Attach attach) {
        super(sessionEndpoint, attach);
        this.setSendingSettlementMode(attach.getSndSettleMode());
        this.setReceivingSettlementMode(attach.getRcvSettleMode());
        this.init();
    }

    private void init() {
        this.setDeliveryCount(UnsignedInteger.valueOf(0));
        this.setAvailable(UnsignedInteger.valueOf(0));
        this.setLinkEventListener(SendingLinkListener.DEFAULT);
    }

    @Override
    public Role getRole() {
        return Role.SENDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transfer(Transfer xfr) {
        SessionEndpoint s = this.getSession();
        int transferCount = this._lastDeliveryTag == null ? 1 : 1;
        xfr.setMessageFormat(UnsignedInteger.ZERO);
        Object object = this.getLock();
        synchronized (object) {
            int currentCredit = this.getLinkCredit().intValue() - transferCount;
            if (currentCredit < 0) {
                return false;
            }
            this.setLinkCredit(UnsignedInteger.valueOf(currentCredit));
            this.setDeliveryCount(UnsignedInteger.valueOf(this.getDeliveryCount().intValue() + transferCount));
            xfr.setHandle(this.getLocalHandle());
            s.sendTransfer(xfr, this, !xfr.getDeliveryTag().equals(this._lastDeliveryTag));
            if (!Boolean.TRUE.equals(xfr.getSettled())) {
                this._unsettledMap.put(xfr.getDeliveryTag(), xfr.getDeliveryId());
            }
        }
        this._lastDeliveryTag = Boolean.TRUE.equals(xfr.getMore()) ? xfr.getDeliveryTag() : null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drained() {
        Object object = this.getLock();
        synchronized (object) {
            this.setDeliveryCount(this.getDeliveryCount().add(this.getLinkCredit()));
            this.setLinkCredit(UnsignedInteger.ZERO);
            this.sendFlow();
        }
    }

    @Override
    public void receiveFlow(Flow flow) {
        super.receiveFlow(flow);
        UnsignedInteger t = flow.getDeliveryCount();
        UnsignedInteger c = flow.getLinkCredit();
        this.setDrain(flow.getDrain());
        Map options = flow.getProperties();
        if (options != null) {
            this._transactionId = (Binary)options.get(Symbol.valueOf("txn-id"));
        }
        if (t == null) {
            this.setLinkCredit(c);
        } else {
            UnsignedInteger limit = t.add(c);
            if (limit.compareTo(this.getDeliveryCount()) <= 0) {
                this.setLinkCredit(UnsignedInteger.valueOf(0));
            } else {
                this.setLinkCredit(limit.subtract(this.getDeliveryCount()));
            }
        }
        this.getSession().getConnection().addPostLockAction(new Runnable(){

            @Override
            public void run() {
                SendingLinkEndpoint.this.flowStateChanged();
            }
        });
    }

    @Override
    public void flowStateChanged() {
        ((SendingLinkListener)this.getLinkEventListener()).flowStateChanged();
    }

    public boolean hasCreditToSend() {
        UnsignedInteger linkCredit = this.getLinkCredit();
        return linkCredit != null && linkCredit.compareTo(UnsignedInteger.valueOf(0)) > 0 && this.getSession().hasCreditToSend();
    }

    @Override
    public void receiveDeliveryState(Delivery unsettled, DeliveryState state, Boolean settled) {
        super.receiveDeliveryState(unsettled, state, settled);
        if (settled.booleanValue()) {
            this._unsettledMap.remove(unsettled.getDeliveryTag());
        }
    }

    public UnsignedInteger getLastDeliveryId() {
        return this._lastDeliveryId;
    }

    public void setLastDeliveryId(UnsignedInteger deliveryId) {
        this._lastDeliveryId = deliveryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisposition(Binary deliveryTag, DeliveryState state, boolean settled) {
        Object object = this.getLock();
        synchronized (object) {
            UnsignedInteger deliveryId;
            if (settled && (deliveryId = this._unsettledMap.remove(deliveryTag)) != null) {
                this.settle(deliveryTag);
                this.getSession().updateDisposition(this.getRole(), deliveryId, deliveryId, state, settled);
            }
        }
    }

    public Binary getTransactionId() {
        return this._transactionId;
    }
}

