/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.security.AccessController;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.CachingSecurityToken;
import org.apache.qpid.server.security.access.config.LegacyAccessControl;
import org.apache.qpid.server.security.access.config.LegacyAccessControlAdapter;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedAccessControl
implements AccessControl<CachingSecurityToken>,
LegacyAccessControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleBasedAccessControl.class);
    private final LegacyAccessControlAdapter _adapter;
    private final RuleSet _ruleSet;

    public RuleBasedAccessControl(RuleSet rs, Model model) {
        this._ruleSet = rs;
        this._adapter = new LegacyAccessControlAdapter(this, model);
    }

    public Result getDefault() {
        return this._ruleSet.getDefault();
    }

    public final CachingSecurityToken newToken() {
        return this.newToken(Subject.getSubject(AccessController.getContext()));
    }

    public CachingSecurityToken newToken(Subject subject) {
        return new CachingSecurityToken(subject, this);
    }

    @Override
    public final Result authorise(LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null || subject.getPrincipals().size() == 0) {
            return Result.DEFER;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking " + operation + " " + objectType);
        }
        try {
            return this._ruleSet.check(subject, operation, objectType, properties);
        }
        catch (Exception e) {
            LOGGER.error("Unable to check " + operation + " " + objectType, (Throwable)e);
            return Result.DENIED;
        }
    }

    public Result authorise(CachingSecurityToken token, Operation operation, PermissionedObject configuredObject) {
        return this.authorise(token, operation, configuredObject, Map.of());
    }

    public Result authorise(CachingSecurityToken token, Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        if (token != null) {
            return token.authorise(this, operation, configuredObject, arguments);
        }
        return this.authorise(operation, configuredObject, arguments);
    }

    Result authorise(Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        return this._adapter.authorise(operation, configuredObject, arguments);
    }
}

