/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.derby.AbstractDerbyMessageStore;
import org.apache.qpid.server.store.derby.DerbyUtils;

public class DerbyMessageStore
extends AbstractDerbyMessageStore {
    private static final Logger LOGGER = Logger.getLogger(DerbyMessageStore.class);
    private String _connectionURL;
    private String _storeLocation;

    @Override
    protected void doOpen(ConfiguredObject<?> parent) {
        FileBasedSettings settings = (FileBasedSettings)parent;
        this._storeLocation = settings.getStorePath();
        this._connectionURL = DerbyUtils.createConnectionUrl(parent.getName(), this._storeLocation);
    }

    protected Connection getConnection() throws SQLException {
        this.checkMessageStoreOpen();
        return DriverManager.getConnection(this._connectionURL);
    }

    @Override
    protected void doClose() {
        try {
            DerbyUtils.shutdownDatabase(this._connectionURL);
        }
        catch (SQLException e) {
            throw new StoreException("Error closing configuration store", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete() {
        if (this.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot delete the store as the message store is still open");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting store " + this._storeLocation));
        }
        try {
            DerbyUtils.deleteDatabaseLocation(this._storeLocation);
        }
        catch (StoreException se) {
            LOGGER.debug((Object)("Failed to delete the store at location " + this._storeLocation));
        }
        finally {
            this._storeLocation = null;
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public String getStoreLocation() {
        return this._storeLocation;
    }
}

