/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.File;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.util.FileUtils;

public class DerbyUtils {
    public static final String MEMORY_STORE_LOCATION = ":memory:";
    public static final String DERBY_SINGLE_DB_SHUTDOWN_CODE = "08006";
    private static final String SQL_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String TABLE_EXISTENCE_QUERY = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = ?";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static void loadDerbyDriver() {
        try {
            Class<?> driverClass = Class.forName(SQL_DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new StoreException("Failed to load driver org.apache.derby.jdbc.EmbeddedDriver", (Throwable)e);
        }
    }

    public static String createConnectionUrl(String name, String databasePath) {
        if (MEMORY_STORE_LOCATION.equals(databasePath)) {
            return "jdbc:derby::memory:/" + name + ";create=true";
        }
        File environmentPath = new File(databasePath);
        if (!environmentPath.exists() && !environmentPath.mkdirs()) {
            throw new IllegalArgumentException("Environment path " + environmentPath + " could not be read or created. " + "Ensure the path is correct and that the permissions are correct.");
        }
        return "jdbc:derby:" + databasePath + "/" + name + ";create=true";
    }

    public static void shutdownDatabase(String connectionURL) throws SQLException {
        block2: {
            try {
                Connection conn = DriverManager.getConnection(connectionURL + ";shutdown=true");
                conn.close();
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase(DERBY_SINGLE_DB_SHUTDOWN_CODE)) break block2;
                throw e;
            }
        }
    }

    public static void deleteDatabaseLocation(String storeLocation) {
        File location;
        if (MEMORY_STORE_LOCATION.equals(storeLocation)) {
            return;
        }
        if (storeLocation != null && (location = new File(storeLocation)).exists() && !FileUtils.delete((File)location, (boolean)true)) {
            throw new StoreException("Failed to delete the store at location : " + storeLocation);
        }
    }

    public static String getBlobAsString(ResultSet rs, int col) throws SQLException {
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    protected static byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(String tableName, Connection conn) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(TABLE_EXISTENCE_QUERY);){
            boolean bl;
            stmt.setString(1, tableName);
            ResultSet rs = stmt.executeQuery();
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
    }
}

